/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.templates.staticexecutable;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.templates.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class StaticExecutableRunner
implements Algorithm {
    public static final String DEFAULT_SAFE_SUBSTITUTE = "_";
    public static final Map<String, String> TROUBLE_CHARACTER_SUBSTITUTIONS;
    public static final String EXECUTABLE_PLACEHOLDER = "executable";
    public static final String DATA_LABEL_PLACEHOLDER = "data_label";
    public static final String IN_FILE_PLACEHOLDER = "inFile";
    private String algorithm;
    private String macOsXPpcDirectoryPath;
    private String macOsX;
    private String algorithmWin32;
    private String win32;
    private String algorithmLinuxX86;
    private String linux;
    private String algorithmDefault;
    private String algorithmDirectoryPath;
    private String temporaryDirectoryPath;
    private Data[] data;
    private Dictionary<String, Object> parameters;
    private Properties properties;
    private CIShellContext ciShellContext;
    private ProgressMonitor monitor;
    private BundleContext bundleContext;
    private String algorithmName;

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("\"", "''");
        m.put(";", DEFAULT_SAFE_SUBSTITUTE);
        m.put(",", DEFAULT_SAFE_SUBSTITUTE);
        m.put("&", DEFAULT_SAFE_SUBSTITUTE);
        m.put("|", DEFAULT_SAFE_SUBSTITUTE);
        m.put("<", DEFAULT_SAFE_SUBSTITUTE);
        m.put(">", DEFAULT_SAFE_SUBSTITUTE);
        TROUBLE_CHARACTER_SUBSTITUTIONS = Collections.unmodifiableMap(m);
    }

    public StaticExecutableRunner(BundleContext bundleContext, CIShellContext ciShellContext, Properties properties, Dictionary<String, Object> parameters, Data[] data, ProgressMonitor monitor, String algorithmName) throws IOException {
        this.bundleContext = bundleContext;
        this.ciShellContext = ciShellContext;
        this.properties = properties;
        this.parameters = parameters;
        this.data = data;
        this.monitor = monitor;
        this.algorithmName = algorithmName;
        this.algorithm = String.valueOf(algorithmName) + "/";
        this.macOsXPpcDirectoryPath = String.valueOf(this.algorithm) + "macosx.ppc/";
        this.macOsX = "macosx";
        this.algorithmWin32 = String.valueOf(this.algorithm) + "win32/";
        this.win32 = "win32";
        this.algorithmLinuxX86 = String.valueOf(this.algorithm) + "linux.x86/";
        this.linux = "linux";
        this.algorithmDefault = String.valueOf(this.algorithm) + "default/";
        if (this.monitor == null) {
            this.monitor = ProgressMonitor.NULL_MONITOR;
        }
        if (this.data == null) {
            this.data = new Data[0];
        }
        if (this.parameters == null) {
            this.parameters = new Hashtable<String, Object>();
        }
        this.temporaryDirectoryPath = this.makeTemporaryDirectory();
        this.algorithmDirectoryPath = String.format("%s%s%s%s", this.temporaryDirectoryPath, File.separator, properties.getProperty("Algorithm-Directory"), File.separator);
    }

    public Data[] execute() throws AlgorithmExecutionException {
        this.copyFilesUsedByExecutableIntoDir(this.getTempDirectory());
        this.makeDirExecutable(this.algorithmDirectoryPath);
        String[] commandLineArguments = this.createCommandLineArguments(this.algorithmDirectoryPath, this.data, this.parameters);
        File[] rawOutput = this.executeProgram(commandLineArguments, this.algorithmDirectoryPath);
        return this.formatAsData(rawOutput);
    }

    private void copyFilesUsedByExecutableIntoDir(File dir) throws AlgorithmExecutionException {
        try {
            Enumeration e = this.bundleContext.getBundle().getEntryPaths("/" + this.algorithmName);
            HashSet<String> entries = new HashSet<String>();
            while (e != null && e.hasMoreElements()) {
                String entryPath = (String)e.nextElement();
                if (!entryPath.endsWith("/")) continue;
                entries.add(entryPath);
            }
            dir = new File(String.valueOf(dir.getPath()) + File.separator + this.algorithmName);
            dir.mkdirs();
            String os = this.bundleContext.getProperty("osgi.os");
            String arch = this.bundleContext.getProperty("osgi.arch");
            String path = null;
            if (entries.contains(this.algorithmDefault)) {
                String defaultPath = this.algorithmDefault;
                this.copyDir(dir, defaultPath, 0);
            }
            if (os.equals(this.win32) && entries.contains(this.algorithmWin32)) {
                path = this.algorithmWin32;
            } else if (os.equals(this.macOsX) && entries.contains(this.macOsXPpcDirectoryPath)) {
                path = this.macOsXPpcDirectoryPath;
            } else if (os.equals(this.linux) && entries.contains(this.algorithmLinuxX86)) {
                path = this.algorithmLinuxX86;
            }
            String platformPath = String.valueOf(this.algorithm) + os + "." + arch + "/";
            if (entries.contains(platformPath)) {
                path = platformPath;
            }
            if (path == null) {
                throw new AlgorithmExecutionException("Unable to find compatible executable");
            }
            this.copyDir(dir, path, 0);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected void makeDirExecutable(String baseDir) throws AlgorithmExecutionException {
        if (new File("/bin/chmod").exists()) {
            try {
                String executable = String.valueOf(baseDir) + this.properties.getProperty(EXECUTABLE_PLACEHOLDER);
                Runtime.getRuntime().exec("/bin/chmod +x " + executable).waitFor();
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
        }
    }

    protected File[] executeProgram(String[] commandArray, String baseDirPath) throws AlgorithmExecutionException {
        File baseDir = new File(baseDirPath);
        Object[] beforeFiles = baseDir.list();
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(commandArray);
            processBuilder.directory(new File(baseDirPath));
            process = processBuilder.start();
            process.getOutputStream().close();
        }
        catch (IOException e1) {
            throw new AlgorithmExecutionException(e1.getMessage(), (Throwable)e1);
        }
        this.monitor.start(4, -1);
        InputStream in = process.getInputStream();
        StringBuffer inBuffer = new StringBuffer();
        InputStream err = process.getErrorStream();
        StringBuffer errBuffer = new StringBuffer();
        Integer exitValue = null;
        boolean killedOnPurpose = false;
        while (!killedOnPurpose && exitValue == null) {
            inBuffer = this.logStream(3, in, inBuffer);
            errBuffer = this.logStream(1, err, errBuffer);
            if (this.monitor.isCanceled()) {
                killedOnPurpose = true;
                process.destroy();
            }
            try {
                int value = process.exitValue();
                exitValue = new Integer(value);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.monitor.done();
        if (process.exitValue() != 0 && !killedOnPurpose) {
            throw new AlgorithmExecutionException("Algorithm exited unexpectedly (exit value: " + process.exitValue() + "). Please check the console window for any error messages.");
        }
        Object[] afterFiles = baseDir.list();
        Arrays.sort(beforeFiles);
        Arrays.sort(afterFiles);
        ArrayList<File> outputs = new ArrayList<File>();
        int beforeIndex = 0;
        int afterIndex = 0;
        while (beforeIndex < beforeFiles.length && afterIndex < afterFiles.length) {
            if (((String)beforeFiles[beforeIndex]).equals(afterFiles[afterIndex])) {
                ++beforeIndex;
                ++afterIndex;
                continue;
            }
            outputs.add(new File(String.valueOf(baseDirPath) + (String)afterFiles[afterIndex]));
            ++afterIndex;
        }
        while (afterIndex < afterFiles.length) {
            outputs.add(new File(String.valueOf(baseDirPath) + (String)afterFiles[afterIndex]));
            ++afterIndex;
        }
        return outputs.toArray(new File[0]);
    }

    protected Data[] formatAsData(File[] files) {
        String outData = (String)this.properties.get("out_data");
        if (outData.trim().equalsIgnoreCase("null")) {
            return null;
        }
        String[] formats = outData.split(",");
        HashMap<String, File> nameToFileMap = new HashMap<String, File>();
        int i = 0;
        while (i < files.length) {
            nameToFileMap.put(files[i].getName(), files[i]);
            ++i;
        }
        Data[] data = null;
        data = formats.length > files.length ? new Data[formats.length] : new Data[files.length];
        int i2 = 0;
        while (i2 < data.length) {
            String file = this.properties.getProperty("outFile[" + i2 + "]", null);
            if (i2 >= formats.length) {
                for (File f : nameToFileMap.values()) {
                    data[i2] = new BasicData((Object)f, "file:text/plain");
                    data[i2].getMetadata().put("Label", f.getName());
                    ++i2;
                }
                break;
            }
            File f = (File)nameToFileMap.remove(file);
            if (f != null) {
                data[i2] = new BasicData((Object)f, formats[i2]);
                String label = this.properties.getProperty("outFile[" + i2 + "].label", f.getName());
                data[i2].getMetadata().put("Label", label);
                String type = this.properties.getProperty("outFile[" + i2 + "].type", "Unknown");
                type = type.trim();
                type = type.equalsIgnoreCase("Matrix") ? "Matrix" : (type.equalsIgnoreCase("Network") ? "Network" : (type.equalsIgnoreCase("Tree") ? "Tree" : (type.equalsIgnoreCase("Text") ? "Text" : (type.equalsIgnoreCase("Plot") ? "Plot" : (type.equalsIgnoreCase("Table") ? "Table" : "Unknown")))));
                data[i2].getMetadata().put("Type", type);
            }
            ++i2;
        }
        return data;
    }

    protected StringBuffer logStream(int logLevel, InputStream is, StringBuffer buffer) throws AlgorithmExecutionException {
        try {
            int available = is.available();
            if (available > 0) {
                byte[] b = new byte[available];
                is.read(b);
                buffer.append(new String(b));
                buffer = this.log(logLevel, buffer);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Error when processing the algorithm's screen output", (Throwable)e);
        }
        return buffer;
    }

    protected StringBuffer log(int logLevel, StringBuffer buffer) {
        if (buffer.indexOf("\n") != -1) {
            LogService log = (LogService)this.ciShellContext.getService(LogService.class.getName());
            int lastGoodIndex = 0;
            int fromIndex = 0;
            while (fromIndex != -1 && fromIndex < buffer.length()) {
                int toIndex = buffer.indexOf("\n", fromIndex);
                if (toIndex != -1) {
                    String message = buffer.substring(fromIndex, toIndex);
                    if (log == null) {
                        System.out.println(message);
                    } else {
                        log.log(logLevel, message);
                    }
                    fromIndex = toIndex + 1;
                    lastGoodIndex = toIndex + 1;
                    continue;
                }
                fromIndex = -1;
            }
            if (lastGoodIndex > 0) {
                buffer = new StringBuffer(buffer.substring(lastGoodIndex));
            }
        }
        return buffer;
    }

    protected String[] createCommandLineArguments(String algorithmDirectory, Data[] data, Dictionary<String, Object> parameters) {
        String template = this.properties.getProperty("template");
        String[] commands = template.split("\\s");
        int ii = 0;
        while (ii < commands.length) {
            commands[ii] = this.substituteVars(commands[ii], data, parameters);
            ++ii;
        }
        if (!new File(String.valueOf(algorithmDirectory) + commands[0]).exists() && new File(String.valueOf(algorithmDirectory) + commands[0] + ".bat").exists()) {
            commands[0] = String.valueOf(commands[0]) + ".bat";
        }
        commands[0] = String.valueOf(algorithmDirectory) + commands[0];
        return commands;
    }

    protected String substituteVars(String template, Data[] data, Dictionary parameters) {
        template = template.replace(String.format("${%s}", EXECUTABLE_PLACEHOLDER), this.properties.getProperty(EXECUTABLE_PLACEHOLDER));
        int ii = 0;
        while (ii < data.length) {
            template = this.substituteForDataLabel(template, data, ii);
            template = this.substituteForFilePath(template, data, ii);
            ++ii;
        }
        Enumeration i = parameters.keys();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            Object value = parameters.get(key);
            if (value == null) {
                value = "";
            }
            template = template.replace(String.format("${%s}", key), value.toString());
        }
        return template;
    }

    private String substituteForDataLabel(String template, Data[] data, int ii) {
        String key = String.format("${%s[%d]}", DATA_LABEL_PLACEHOLDER, ii);
        if (!template.contains(key)) {
            return template;
        }
        Object labelObject = data[ii].getMetadata().get("Label");
        String label = "unknown_data_label";
        if (labelObject != null) {
            label = labelObject.toString();
        }
        String cleanedLabel = this.cleanDataLabel(label);
        return template.replace(key, cleanedLabel);
    }

    private String cleanDataLabel(String label) {
        String cleanedLabel = label;
        for (String troubleCharacter : TROUBLE_CHARACTER_SUBSTITUTIONS.keySet()) {
            cleanedLabel = cleanedLabel.replace(troubleCharacter, TROUBLE_CHARACTER_SUBSTITUTIONS.get(troubleCharacter));
        }
        return cleanedLabel;
    }

    private String substituteForFilePath(String template, Data[] data, int ii) {
        String key = String.format("${%s[%d]}", IN_FILE_PLACEHOLDER, ii);
        if (!template.contains(key)) {
            return template;
        }
        Object datumObject = data[ii].getData();
        String filePath = "unknown_file_path";
        if (datumObject != null && datumObject instanceof File) {
            File file = (File)datumObject;
            filePath = file.getAbsolutePath();
        }
        String substituted = template.replace(key, filePath);
        return substituted;
    }

    public File getTempDirectory() {
        return new File(this.temporaryDirectoryPath);
    }

    protected String makeTemporaryDirectory() throws IOException {
        File sessionDir = Activator.getTempDirectory();
        File dir = File.createTempFile("StaticExecutableRunner-", "", sessionDir);
        dir.delete();
        dir.mkdirs();
        return dir.getAbsolutePath();
    }

    private void copyDir(File dir, String dirPath, int depth) throws IOException {
        Enumeration e = this.bundleContext.getBundle().getEntryPaths(dirPath);
        while (e != null && e.hasMoreElements()) {
            String path = (String)e.nextElement();
            if (path.endsWith("/")) {
                String dirName = this.getName(path);
                File subDirectory = new File(String.valueOf(dir.getPath()) + File.separator + dirName);
                subDirectory.mkdirs();
                this.copyDir(subDirectory, path, depth + 1);
                continue;
            }
            this.copyFile(dir, path);
        }
    }

    private void copyFile(File dir, String path) throws IOException {
        URL entry = this.bundleContext.getBundle().getEntry(path);
        String file = this.getName(path);
        FileOutputStream outStream = new FileOutputStream(String.valueOf(dir.getPath()) + File.separator + file);
        ReadableByteChannel in = Channels.newChannel(entry.openStream());
        FileChannel out = outStream.getChannel();
        out.transferFrom(in, 0L, Integer.MAX_VALUE);
        in.close();
        out.close();
    }

    private String getName(String path) {
        if (path.lastIndexOf(47) == path.length() - 1) {
            path = path.substring(0, path.length() - 1);
        }
        path = path.substring(path.lastIndexOf(47) + 1, path.length());
        return path;
    }
}

