/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities;

import com.google.common.collect.ImmutableMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.cishell.utilities.FileCopyingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogService;

@Deprecated
public class FileUtilities {
    public static final int READ_TEXT_FILE_BUFFER_SIZE = 1024;
    public static final String DEFAULT_STREAM_TO_FILE_NAME = "stream_";
    public static final ImmutableMap<String, String> MIME_TYPE_TO_FILE_EXTENSION = new ImmutableMap.Builder().put((Object)"file:application/pajekmat", (Object)"mat").put((Object)"file:application/pajeknet", (Object)"net").put((Object)"file:application/parvis", (Object)"stf").put((Object)"file:text/bibtex", (Object)"bib").put((Object)"file:text/compartmentalmodel", (Object)"mdl").put((Object)"file:text/coord", (Object)"nwb").put((Object)"file:text/grace", (Object)"grace.dat").put((Object)"file:text/intsim", (Object)"int").put((Object)"file:text/plain", (Object)"txt").put((Object)"file:text/plot", (Object)"plot.dat").put((Object)"file:text/referbib", (Object)"refer").build();
    public static final char FILENAME_CHARACTER_REPLACEMENT = '#';
    public static final Collection INVALID_FILENAME_CHARACTERS;
    private static int uniqueIntForTempFile;

    static {
        HashSet<Character> s = new HashSet<Character>();
        s.add(new Character('\\'));
        s.add(new Character('/'));
        s.add(new Character(':'));
        s.add(new Character('*'));
        s.add(new Character('?'));
        s.add(new Character('\"'));
        s.add(new Character('<'));
        s.add(new Character('>'));
        s.add(new Character('|'));
        s.add(new Character('%'));
        INVALID_FILENAME_CHARACTERS = Collections.unmodifiableCollection(s);
        uniqueIntForTempFile = 1;
    }

    public static File createTemporaryDirectory(String temporaryDirectoryPath) {
        String fullDirectoryPath = String.format("%s%stemp", temporaryDirectoryPath, File.separator);
        return FileUtilities.ensureDirectoryExists(fullDirectoryPath);
    }

    public static File createTempDirectory(String prefix) {
        File baseDir = new File(FileUtilities.getDefaultTemporaryDirectory());
        String baseName = String.valueOf(prefix) + "-" + System.currentTimeMillis() + "-";
        int counter = 0;
        while (counter < 1000) {
            File tempDir = new File(baseDir, String.valueOf(baseName) + counter);
            if (tempDir.mkdir()) {
                return tempDir;
            }
            ++counter;
        }
        throw new IllegalStateException("Failed to create directory within 1000 attempts (tried " + baseName + "0 to " + baseName + 999 + ')');
    }

    public static File createTemporaryFile(File temporaryDirectory, String temporaryDirectoryPath, String temporaryFileName, String temporaryFileExtension) {
        File temporaryFile;
        block4: {
            FileUtilities.ensureDirectoryExists(temporaryDirectoryPath);
            try {
                temporaryFile = File.createTempFile(temporaryFileName, "." + temporaryFileExtension, temporaryDirectory);
            }
            catch (IOException iOException) {
                temporaryFile = new File(String.valueOf(temporaryDirectoryPath) + File.separator + temporaryFileName + "temp." + temporaryFileExtension);
                if (temporaryFile.exists()) break block4;
                try {
                    temporaryFile.createNewFile();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                temporaryFile.deleteOnExit();
            }
        }
        return temporaryFile;
    }

    public static File createTemporaryFileInTemporaryDirectory(String temporaryDirectoryPath, String temporaryFileName, String temporaryFileExtension) throws IOException {
        File temporaryDirectory = FileUtilities.createTemporaryDirectory(temporaryDirectoryPath);
        File temporaryFile = FileUtilities.createTemporaryFile(temporaryDirectory, temporaryDirectoryPath, temporaryFileName, temporaryFileExtension);
        if (temporaryFile == null) {
            throw new IOException("Failed to generate a file in the temporary directory.");
        }
        return temporaryFile;
    }

    public static String getDefaultTemporaryDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File createTemporaryFileInDefaultTemporaryDirectory(String temporaryFileName, String temporaryFileExtension) throws IOException {
        return FileUtilities.createTemporaryFileInTemporaryDirectory(FileUtilities.getDefaultTemporaryDirectory(), temporaryFileName, temporaryFileExtension);
    }

    public static File writeBufferedImageIntoTemporaryDirectory(BufferedImage bufferedImage, String imageType) throws IOException, Exception {
        String temporaryDirectoryPath = FileUtilities.getDefaultTemporaryDirectory();
        File temporaryImageFile = FileUtilities.createTemporaryFileInTemporaryDirectory(temporaryDirectoryPath, "image-", imageType);
        if (!ImageIO.write((RenderedImage)bufferedImage, imageType, temporaryImageFile)) {
            throw new Exception("No valid image writer was found for the image type " + imageType);
        }
        return temporaryImageFile;
    }

    public static File writeTextIntoTemporaryDirectory(String text, String fileExtension) throws IOException, Exception {
        String temporaryDirectoryPath = FileUtilities.getDefaultTemporaryDirectory();
        File temporaryTextFile = FileUtilities.createTemporaryFileInTemporaryDirectory(temporaryDirectoryPath, "text-", fileExtension);
        FileWriter textFileWriter = new FileWriter(temporaryTextFile);
        textFileWriter.write(text);
        textFileWriter.flush();
        return temporaryTextFile;
    }

    public static boolean isFileEmpty(File file) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String firstLine = reader.readLine();
        reader.close();
        boolean fileIsEmpty = firstLine == null;
        return fileIsEmpty;
    }

    public static String readEntireTextFile(File file) throws IOException {
        return FileUtilities.extractReaderContents(new BufferedReader(new FileReader(file)));
    }

    public static String readEntireInputStream(InputStream stream) throws IOException {
        return FileUtilities.extractReaderContents(new BufferedReader(new InputStreamReader(stream)));
    }

    public static String extractReaderContents(BufferedReader bufferedReader) throws IOException {
        StringBuffer contents = new StringBuffer();
        char[] readInCharacters = new char[1];
        int readCharacterCount = bufferedReader.read(readInCharacters);
        while (readCharacterCount > -1) {
            contents.append(String.valueOf(readInCharacters));
            readCharacterCount = bufferedReader.read(readInCharacters);
        }
        bufferedReader.close();
        return contents.toString();
    }

    public static void copyFile(File sourceFile, File targetFile) throws FileCopyingException {
        try {
            FileInputStream inputStream = new FileInputStream(sourceFile);
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            FileChannel readableChannel = inputStream.getChannel();
            FileChannel writableChannel = outputStream.getChannel();
            writableChannel.truncate(0L);
            writableChannel.transferFrom(readableChannel, 0L, readableChannel.size());
            inputStream.close();
            outputStream.close();
        }
        catch (IOException ioException) {
            String exceptionMessage = "An error occurred when copying from the file \"" + sourceFile.getAbsolutePath() + "\" to the file \"" + targetFile.getAbsolutePath() + "\".";
            throw new FileCopyingException(exceptionMessage, ioException);
        }
    }

    public static File createTemporaryFileCopy(File sourceFile, String fileName, String fileExtension) throws FileCopyingException {
        try {
            File temporaryTargetFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory(fileName, fileExtension);
            FileUtilities.copyFile(sourceFile, temporaryTargetFile);
            return temporaryTargetFile;
        }
        catch (IOException temporaryFileCreationException) {
            String exceptionMessage = "An error occurred when trying to create the temporary file with file name \"" + fileName + "\" " + "and file extension \"" + fileExtension + "\" " + "for copying file \"" + sourceFile.getAbsolutePath() + "\".";
            throw new FileCopyingException(exceptionMessage, temporaryFileCreationException);
        }
    }

    public static File loadFileFromClassPath(Class clazz, String filePath) {
        URL fileURL = clazz.getResource(filePath);
        return new File(URI.create(fileURL.toString()));
    }

    public static File safeLoadFileFromClasspath(Class clazz, String filePath) throws IOException {
        InputStream input = clazz.getResourceAsStream(filePath);
        String fileExtension = FileUtilities.getFileExtension(filePath);
        return FileUtilities.writeEntireStreamToTemporaryFile(input, fileExtension);
    }

    public static File writeEntireStreamToTemporaryFile(InputStream stream, String fileExtension) throws IOException {
        return FileUtilities.writeEntireStreamToTemporaryFile(stream, DEFAULT_STREAM_TO_FILE_NAME, fileExtension);
    }

    public static File writeEntireStreamToTemporaryFile(InputStream input, String fileName, String fileExtension) throws IOException {
        File temporaryFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory(fileName, fileExtension);
        FileOutputStream output = new FileOutputStream(temporaryFile);
        byte[] readCharacters = new byte[1];
        int readCharacterCount = input.read(readCharacters);
        while (readCharacterCount > 0) {
            ((OutputStream)output).write(readCharacters, 0, readCharacterCount);
            readCharacterCount = input.read(readCharacters);
        }
        ((OutputStream)output).close();
        input.close();
        return temporaryFile;
    }

    public static File writeEntireStreamToTemporaryFileInDirectory(InputStream input, File directory, String fileName, String fileExtension) throws IOException {
        File temporaryFile = FileUtilities.createTemporaryFile(directory, directory.getAbsolutePath(), fileName, fileExtension);
        return FileUtilities.writeStreamToFile(input, temporaryFile);
    }

    public static File writeStreamToFile(InputStream input, File outputFile) throws IOException {
        FileOutputStream output = new FileOutputStream(outputFile);
        byte[] readCharacters = new byte[1];
        int readCharacterCount = input.read(readCharacters);
        while (readCharacterCount > 0) {
            ((OutputStream)output).write(readCharacters, 0, readCharacterCount);
            readCharacterCount = input.read(readCharacters);
        }
        ((OutputStream)output).close();
        input.close();
        return outputFile;
    }

    public static String getFileExtension(File file) {
        return FileUtilities.getFileExtension(file.getAbsolutePath());
    }

    public static String getFileExtension(String filePath) {
        int periodPosition = filePath.lastIndexOf(".");
        if (periodPosition != -1 && periodPosition + 1 < filePath.length()) {
            return filePath.substring(periodPosition);
        }
        return "";
    }

    private static File ensureDirectoryExists(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
            directory.deleteOnExit();
        }
        return directory;
    }

    public static File getTempFile(String fileName, String extension, LogService logger) {
        File tempFile;
        String tempPath;
        File tempDir;
        if (fileName == null || fileName.equals("")) {
            fileName = "unknown";
        }
        if (extension == null || extension.equals("")) {
            extension = ".txt";
        }
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        if (!(tempDir = new File(String.valueOf(tempPath = System.getProperty("java.io.tmpdir")) + File.separator + "nwb")).exists()) {
            tempDir.mkdir();
        }
        try {
            tempFile = File.createTempFile(fileName, extension, tempDir);
        }
        catch (IOException e1) {
            logger.log(2, "Failed to create temp file with provided name and extension '" + fileName + extension + "'. Trying a generic name and extension instead.", (Throwable)e1);
            try {
                tempFile = File.createTempFile("unknown", ".txt", tempDir);
            }
            catch (IOException e2) {
                tempFile = new File(String.valueOf(tempPath) + File.separator + "nwb" + File.separator + "unknown" + uniqueIntForTempFile + ".txt");
                ++uniqueIntForTempFile;
                logger.log(1, "Failed to create temp file twice...");
                logger.log(1, "First Try... \r\n " + e1.toString());
                logger.log(1, "Second Try... \r\n " + e2.toString());
            }
        }
        return tempFile;
    }

    public static String extractExtension(String format) {
        String extension = "";
        if (format.startsWith("file-ext:")) {
            extension = format.substring("file-ext:".length());
        } else if (format.startsWith("file:")) {
            extension = MIME_TYPE_TO_FILE_EXTENSION.containsKey((Object)format) ? (String)MIME_TYPE_TO_FILE_EXTENSION.get((Object)format) : (format.contains("/") ? format.substring(format.indexOf("/") + 1) : format.substring("file:".length()));
        }
        extension = extension.replace('+', '.');
        return extension;
    }

    public static String replaceInvalidFilenameCharacters(String filename) {
        String cleanedFilename = filename;
        Iterator invalidCharacters = INVALID_FILENAME_CHARACTERS.iterator();
        while (invalidCharacters.hasNext()) {
            char invalidCharacter = ((Character)invalidCharacters.next()).charValue();
            cleanedFilename = cleanedFilename.replace(invalidCharacter, '#');
        }
        return cleanedFilename;
    }

    public static String extractFileName(String fileLabel) {
        int filePathEndIndex;
        int descriptionEndIndex = fileLabel.lastIndexOf(":");
        int startIndex = Math.max(descriptionEndIndex, filePathEndIndex = fileLabel.lastIndexOf(File.separator)) + 1;
        String fileNameWithExtension = fileLabel.substring(startIndex);
        int extensionBeginIndex = fileNameWithExtension.lastIndexOf(".");
        int endIndex = extensionBeginIndex != -1 ? extensionBeginIndex : fileNameWithExtension.length();
        String fileNameWithoutExtension = fileNameWithExtension.substring(0, endIndex);
        return fileNameWithoutExtension.trim();
    }

    public static String extractFileNameWithExtension(String fileLabel) {
        return String.valueOf(FileUtilities.extractFileName(fileLabel)) + FileUtilities.getFileExtension(fileLabel);
    }

    public static URL lookupResourceUrl(Class<?> callingClass, String resourceFilename) {
        BundleContext bC = FrameworkUtil.getBundle(callingClass).getBundleContext();
        return bC.getBundle().getResource(resourceFilename);
    }
}

