/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.text.ParseException;
import org.cishell.utilities.NumberUtilities;

@Deprecated
public class PrefuseUtilities {
    private PrefuseUtilities() {
        throw new AssertionError();
    }

    public static Number interpretObjectAsNumber(Object object) throws EmptyInterpretedObjectException, UninterpretableObjectException {
        Preconditions.checkNotNull((Object)object, (Object)"The object must not be null.");
        try {
            return NumberUtilities.interpretObjectAsNumber(object);
        }
        catch (NumberFormatException e) {
            if ("An empty number cell was found.".equals(e.getMessage())) {
                throw new EmptyInterpretedObjectException(e);
            }
            throw new UninterpretableObjectException(e);
        }
        catch (ParseException e) {
            throw new UninterpretableObjectException(e);
        }
    }

    public static Integer interpretObjectAsInteger(Object object) throws EmptyInterpretedObjectException, UninterpretableObjectException {
        Preconditions.checkNotNull((Object)object, (Object)"The object must not be null.");
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.intValue();
        }
        if (object instanceof short[]) {
            short[] objectAsShortArray = (short[])object;
            if (objectAsShortArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsShortArray[0];
        }
        if (object instanceof Short[]) {
            Short[] objectAsShortArray = (Short[])object;
            if (objectAsShortArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsShortArray[0].intValue();
        }
        if (object instanceof int[]) {
            int[] objectAsIntArray = (int[])object;
            if (objectAsIntArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsIntArray[0];
        }
        if (object instanceof Integer[]) {
            Integer[] objectAsIntegerArray = (Integer[])object;
            if (objectAsIntegerArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsIntegerArray[0];
        }
        if (object instanceof long[]) {
            long[] objectAsLongArray = (long[])object;
            if (objectAsLongArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return PrefuseUtilities.checkedCast(objectAsLongArray[0]);
        }
        if (object instanceof Long[]) {
            Long[] objectAsLongArray = (Long[])object;
            if (objectAsLongArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return PrefuseUtilities.checkedCast(objectAsLongArray[0]);
        }
        if (object instanceof float[]) {
            float[] objectAsFloatArray = (float[])object;
            if (objectAsFloatArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsFloatArray[0]).intValue();
        }
        if (object instanceof Float[]) {
            Float[] objectAsFloatArray = (Float[])object;
            if (objectAsFloatArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsFloatArray[0].intValue();
        }
        if (object instanceof double[]) {
            double[] objectAsDoubleArray = (double[])object;
            if (objectAsDoubleArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Double(objectAsDoubleArray[0]).intValue();
        }
        if (object instanceof Double[]) {
            Double[] objectAsDoubleArray = (Double[])object;
            if (objectAsDoubleArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsDoubleArray[0].intValue();
        }
        String objectAsString = object.toString();
        try {
            return Integer.valueOf(objectAsString);
        }
        catch (NumberFormatException e) {
            throw new UninterpretableObjectException(e);
        }
    }

    public static Double interpretObjectAsDouble(Object object) throws EmptyInterpretedObjectException, UninterpretableObjectException {
        Preconditions.checkNotNull((Object)object, (Object)"The object must not be null.");
        try {
            return NumberUtilities.interpretObjectAsDouble(object);
        }
        catch (NumberFormatException e) {
            if ("An empty number cell was found.".equals(e.getMessage())) {
                throw new EmptyInterpretedObjectException(e);
            }
            throw new UninterpretableObjectException(e);
        }
    }

    public static Float interpretObjectAsFloat(Object object) throws EmptyInterpretedObjectException, UninterpretableObjectException {
        Preconditions.checkNotNull((Object)object, (Object)"The object must not be null.");
        if (object instanceof Number) {
            Number number = (Number)object;
            return new Float(number.floatValue());
        }
        if (object instanceof short[]) {
            short[] objectAsShortArray = (short[])object;
            if (objectAsShortArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsShortArray[0]);
        }
        if (object instanceof Short[]) {
            Short[] objectAsShortArray = (Short[])object;
            if (objectAsShortArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsShortArray[0].floatValue());
        }
        if (object instanceof int[]) {
            int[] objectAsIntArray = (int[])object;
            if (objectAsIntArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsIntArray[0]);
        }
        if (object instanceof Integer[]) {
            Integer[] objectAsIntegerArray = (Integer[])object;
            if (objectAsIntegerArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsIntegerArray[0].floatValue());
        }
        if (object instanceof long[]) {
            long[] objectAsLongArray = (long[])object;
            if (objectAsLongArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsLongArray[0]);
        }
        if (object instanceof Long[]) {
            Long[] objectAsLongArray = (Long[])object;
            if (objectAsLongArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsLongArray[0].floatValue());
        }
        if (object instanceof float[]) {
            float[] objectAsFloatArray = (float[])object;
            if (objectAsFloatArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsFloatArray[0]);
        }
        if (object instanceof Float[]) {
            Float[] objectAsFloatArray = (Float[])object;
            if (objectAsFloatArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsFloatArray[0].floatValue());
        }
        if (object instanceof double[]) {
            double[] objectAsDoubleArray = (double[])object;
            if (objectAsDoubleArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsDoubleArray[0]);
        }
        if (object instanceof Double[]) {
            Double[] objectAsDoubleArray = (Double[])object;
            if (objectAsDoubleArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return new Float(objectAsDoubleArray[0].floatValue());
        }
        String objectAsString = object.toString();
        try {
            return new Float(objectAsString);
        }
        catch (NumberFormatException e) {
            throw new UninterpretableObjectException(e);
        }
    }

    public static Boolean interpretObjectAsBoolean(Object object) throws EmptyInterpretedObjectException {
        Preconditions.checkNotNull((Object)object, (Object)"The object must not be null.");
        if (object instanceof boolean[]) {
            boolean[] objectAsBooleanArray = (boolean[])object;
            if (objectAsBooleanArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsBooleanArray[0];
        }
        if (object instanceof Boolean[]) {
            Boolean[] objectAsBooleanArray = (Boolean[])object;
            if (objectAsBooleanArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsBooleanArray[0];
        }
        String objectAsString = object.toString();
        return Boolean.valueOf(objectAsString);
    }

    public static String interpretObjectAsString(Object object) throws EmptyInterpretedObjectException {
        Preconditions.checkNotNull((Object)object, (Object)"The object must not be null.");
        if (object instanceof String[]) {
            String[] objectAsBooleanArray = (String[])object;
            if (objectAsBooleanArray.length == 0) {
                throw new EmptyInterpretedObjectException("An empty number cell was found.");
            }
            return objectAsBooleanArray[0];
        }
        return object.toString();
    }

    public static Object removePrefuseArrayWrapper(Object object) {
        Preconditions.checkNotNull((Object)object);
        Object returnObject = object;
        if (object.getClass().isArray()) {
            if (Array.getLength(object) == 0) {
                returnObject = null;
            } else if (Array.getLength(object) == 1) {
                Object fromArray = Array.get(object, 0);
                returnObject = fromArray.getClass().isArray() ? ((Object[])fromArray)[0] : fromArray;
            }
        }
        return returnObject;
    }

    private static int checkedCast(long value) {
        int result = (int)value;
        if ((long)result != value) {
            throw new IllegalArgumentException("Out of range: " + value);
        }
        return result;
    }

    public static class EmptyInterpretedObjectException
    extends PrefuseInterpretationException {
        private static final long serialVersionUID = 7761769662476407624L;

        public EmptyInterpretedObjectException() {
        }

        public EmptyInterpretedObjectException(String message) {
            super(message);
        }

        public EmptyInterpretedObjectException(Throwable cause) {
            super(cause);
        }

        public EmptyInterpretedObjectException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PrefuseInterpretationException
    extends Exception {
        private static final long serialVersionUID = 4798889267693852796L;

        public PrefuseInterpretationException() {
        }

        public PrefuseInterpretationException(String message) {
            super(message);
        }

        public PrefuseInterpretationException(Throwable cause) {
            super(cause);
        }

        public PrefuseInterpretationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class UninterpretableObjectException
    extends PrefuseInterpretationException {
        private static final long serialVersionUID = 958527035061832770L;

        public UninterpretableObjectException() {
        }

        public UninterpretableObjectException(String message) {
            super(message);
        }

        public UninterpretableObjectException(Throwable cause) {
            super(cause);
        }

        public UninterpretableObjectException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

