/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

@Deprecated
public class StringUtilities {
    public static Pattern NON_ALPHA_NUMERIC_CHARACTER_ESCAPE = Pattern.compile("([^a-zA-z0-9])");

    public static String implodeStringArray(String[] stringArray, String separator) {
        int stringArrayLength = stringArray.length;
        StringBuffer workingResultString = new StringBuffer();
        int ii = 0;
        while (ii < stringArrayLength) {
            workingResultString.append(stringArray[ii]);
            if (ii != stringArrayLength - 1) {
                workingResultString.append(separator);
            }
            ++ii;
        }
        return workingResultString.toString();
    }

    public static String implodeList(List list, String separator) {
        return StringUtilities.implodeItems(list, separator);
    }

    public static <T> String implodeItems(Collection<T> items, String separator) {
        StringBuffer workingResultString = new StringBuffer();
        Iterator<T> it = items.iterator();
        while (it.hasNext()) {
            boolean isLastElement;
            workingResultString.append(it.next());
            boolean bl = isLastElement = !it.hasNext();
            if (isLastElement) continue;
            workingResultString.append(separator);
        }
        return workingResultString.toString();
    }

    public static String[] filterStringsByPattern(String[] stringsToFilter, String pattern) {
        ArrayList<String> filteredStrings = new ArrayList<String>();
        int ii = 0;
        while (ii < stringsToFilter.length) {
            if (!stringsToFilter[ii].matches(pattern)) {
                filteredStrings.add(stringsToFilter[ii]);
            }
            ++ii;
        }
        return filteredStrings.toArray(new String[0]);
    }

    public static String[] filterEmptyStrings(String[] stringsToFilter) {
        ArrayList<String> filteredStrings = new ArrayList<String>();
        int ii = 0;
        while (ii < stringsToFilter.length) {
            if (!"".equals(stringsToFilter[ii])) {
                filteredStrings.add(stringsToFilter[ii]);
            }
            ++ii;
        }
        return filteredStrings.toArray(new String[0]);
    }

    public static String interpretObjectAsString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            String[] objectAsStringArray = (String[])object;
            if (objectAsStringArray.length == 0) {
                return null;
            }
            return objectAsStringArray[0];
        }
        return object.toString();
    }

    public static boolean isEmptyOrWhitespace(String string) {
        String trimmed = string.trim();
        return trimmed.length() == 0;
    }

    public static boolean allAreEmptyOrWhitespace(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!StringUtilities.isEmptyOrWhitespace(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean allAreNeitherEmptyNorWhitespace(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (StringUtilities.isEmptyOrWhitespace(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNull_Empty_OrWhitespace(String string) {
        if (string == null) {
            return true;
        }
        return StringUtilities.isEmptyOrWhitespace(string);
    }

    public static boolean allAreNull_Empty_OrWhitespace(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!StringUtilities.isNull_Empty_OrWhitespace(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean allAreNeitherNullNorEmptyNorWhitespace(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (StringUtilities.isNull_Empty_OrWhitespace(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int countOccurrencesOfChar(CharSequence characters, char target) {
        int count = 0;
        int ii = 0;
        while (ii < characters.length()) {
            if (characters.charAt(ii) == target) {
                ++count;
            }
            ++ii;
        }
        return count;
    }

    public static String multiply(String target, int count) {
        if (count < 1) {
            return "";
        }
        StringBuffer stringInProgress = new StringBuffer();
        int ii = 0;
        while (ii < count) {
            stringInProgress.append(target);
            ++ii;
        }
        return stringInProgress.toString();
    }

    public static String multiplyWithSeparator(String target, String separator, int count) {
        String multipliedWithExtraSeparator = StringUtilities.multiply(String.valueOf(target) + separator, count);
        return multipliedWithExtraSeparator.substring(0, multipliedWithExtraSeparator.length() - separator.length());
    }

    public static String emptyStringIfNull(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String simpleClean(String string) {
        String guaranteedToNotBeNull = StringUtilities.emptyStringIfNull(string);
        return guaranteedToNotBeNull.trim();
    }

    public static final String[] simpleCleanStrings(String[] strings) {
        ArrayList<String> cleanedStrings = new ArrayList<String>();
        int ii = 0;
        while (ii < strings.length) {
            cleanedStrings.add(StringUtilities.simpleClean(strings[ii]));
            ++ii;
        }
        return cleanedStrings.toArray(new String[0]);
    }

    public static String trimIfNotNull(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static String toSentenceCase(String word) {
        String cleanedWord = StringUtilities.simpleClean(word);
        if (cleanedWord.length() == 0) {
            return "";
        }
        return String.valueOf(Character.toUpperCase(cleanedWord.charAt(0))) + cleanedWord.substring(1).toLowerCase();
    }

    public static int prefixIndex(String target, String[] prefixes) {
        int ii = prefixes.length - 1;
        while (ii >= 0) {
            if (target.startsWith(prefixes[ii])) {
                return ii;
            }
            --ii;
        }
        return -1;
    }

    public static boolean areValidAndEqual(String string1, String string2) {
        return !StringUtilities.isNull_Empty_OrWhitespace(string1) && !StringUtilities.isNull_Empty_OrWhitespace(string2) && string1.equals(string2);
    }

    public static boolean bothAreEqualOrNull(String string1, String string2) {
        if (string1 != null) {
            return string1.equals(string2);
        }
        return string2 == null;
    }

    public static boolean areValidAndEqualIgnoreCase(String string1, String string2) {
        return !StringUtilities.isNull_Empty_OrWhitespace(string1) && !StringUtilities.isNull_Empty_OrWhitespace(string2) && string1.equalsIgnoreCase(string2);
    }

    public static String simpleMerge(String string1, String string2) {
        if (!StringUtilities.isNull_Empty_OrWhitespace(string1)) {
            if (!StringUtilities.isNull_Empty_OrWhitespace(string2)) {
                if (string1.length() >= string2.length()) {
                    return string1;
                }
                return string2;
            }
            return string1;
        }
        if (!StringUtilities.isNull_Empty_OrWhitespace(string2)) {
            return string2;
        }
        return string1;
    }

    public static Object alternativeIfNotNull_Empty_OrWhitespace(String string, Object alternative) {
        if (!StringUtilities.isNull_Empty_OrWhitespace(string)) {
            return string;
        }
        return alternative;
    }

    public static Object alternativeIfNotNull_Empty_OrWhitespace_IgnoreCase(String string, Object alternative) {
        if (!StringUtilities.isNull_Empty_OrWhitespace(string)) {
            return string.toLowerCase();
        }
        return alternative;
    }

    public static String getNthToken(String originalString, String separator, int index, boolean trim, boolean escapeForRegularExpression) {
        return StringUtilities.getAllTokens(originalString, separator, trim, escapeForRegularExpression)[index];
    }

    public static String[] getAllTokens(String originalString, String separator, boolean trim, boolean escapeForRegularExpression) {
        if (escapeForRegularExpression) {
            separator = StringUtilities.escapeForRegularExpression(separator);
        }
        String[] tokens = originalString.split(separator);
        if (trim) {
            String[] trimmedTokens = new String[tokens.length];
            int ii = 0;
            while (ii < tokens.length) {
                trimmedTokens[ii] = tokens[ii].trim();
                ++ii;
            }
            return trimmedTokens;
        }
        return tokens;
    }

    public static String[] tokenizeByWhitespace(String originalString) {
        StringTokenizer tokenizer = new StringTokenizer(originalString);
        int tokenCount = tokenizer.countTokens();
        String[] tokens = new String[tokenCount];
        int ii = 0;
        while (ii < tokenCount) {
            tokens[ii] = tokenizer.nextToken();
            ++ii;
        }
        return tokens;
    }

    public static String stripSurroundingQuotes(String quoted) {
        if (quoted.startsWith("\"")) {
            if (quoted.endsWith("\"")) {
                return quoted.substring(1, quoted.length() - 1);
            }
            return quoted.substring(1);
        }
        return quoted;
    }

    public static String escapeForRegularExpression(String original) {
        return NON_ALPHA_NUMERIC_CHARACTER_ESCAPE.matcher(original).replaceAll("\\\\$1");
    }

    public static String getStackTraceAsString(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public static String mapToString(Map<?, ?> map, String mapSeparator, String separator) {
        ArrayList<String> mappedStrings = new ArrayList<String>();
        for (Object key : map.keySet()) {
            String mappedString = String.format("%s%s%s", key.toString(), mapSeparator, map.get(key).toString());
            mappedStrings.add(mappedString);
        }
        return StringUtilities.implodeList(mappedStrings, separator);
    }
}

