/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.cishell.utilities.ColumnNotFoundException;
import org.cishell.utilities.NumberUtilities;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.util.collections.IntIterator;

@Deprecated
public class TableUtilities {
    public static final Class<?>[] POSSIBLE_NUMBER_CLASSES = new Class[]{Byte.TYPE, byte[].class, Byte.class, Byte[].class, Short.TYPE, short[].class, Short.class, Short[].class, Integer.TYPE, int[].class, Integer.class, Integer[].class, Long.TYPE, long[].class, Long.class, Long[].class, Float.TYPE, float[].class, Float.class, Float[].class, Double.TYPE, double[].class, Double.class, Double[].class};
    public static final Class<?>[] POSSIBLE_INTEGER_CLASSES = new Class[]{Integer.TYPE, Integer.class, int[].class, Integer[].class};
    public static final Class<?>[] POSSIBLE_DATE_CLASSES = new Class[]{Date.class, Integer.TYPE, Integer.class, String.class, int[].class, Integer[].class, String[].class};

    public static Table copyTable(Table oldTable) {
        Schema oldSchema = oldTable.getSchema();
        Table newTable = oldSchema.instantiate();
        Iterator rowIt = oldTable.tuples();
        while (rowIt.hasNext()) {
            Tuple row = (Tuple)rowIt.next();
            newTable.addTuple(row);
        }
        return newTable;
    }

    public static Table copyNRowsFromTableUsingIntIterator(Table originalTable, IntIterator iterator, int topN, boolean isDescending) {
        Schema tableSchema = originalTable.getSchema();
        int numTableRows = originalTable.getRowCount();
        Table newTable = TableUtilities.createTableUsingSchema(tableSchema);
        int numRowsToCopy = Math.min(numTableRows, topN);
        int[] originalTableRowsToCopy = new int[numTableRows];
        newTable.addRows(numRowsToCopy);
        int ii = 0;
        while (ii < numTableRows) {
            originalTableRowsToCopy[ii] = iterator.nextInt();
            ++ii;
        }
        if (!isDescending) {
            ii = 0;
            while (ii < numRowsToCopy) {
                TableUtilities.copyTableRow(ii, originalTableRowsToCopy[ii], newTable, originalTable);
                ++ii;
            }
        } else {
            ii = 0;
            while (ii < numRowsToCopy) {
                TableUtilities.copyTableRow(ii, originalTableRowsToCopy[numTableRows - ii - 1], newTable, originalTable);
                ++ii;
            }
        }
        return newTable;
    }

    public static void copyTableRow(int newTableRow, int originalTableRow, Table newTable, Table originalTable) {
        int numTableColumns = originalTable.getColumnCount();
        int ii = 0;
        while (ii < numTableColumns) {
            newTable.set(newTableRow, ii, originalTable.get(originalTableRow, ii));
            ++ii;
        }
    }

    public static List<String> getAllColumnNames(Schema schema) throws ColumnNotFoundException {
        ArrayList<String> workingColumnNames = new ArrayList<String>();
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            workingColumnNames.add(schema.getColumnName(ii));
            ++ii;
        }
        if (workingColumnNames.size() == 0) {
            throw new ColumnNotFoundException("No columns found in the schema.");
        }
        return workingColumnNames;
    }

    public static String[] getValidStringColumnNamesInTable(Table table) throws ColumnNotFoundException {
        return TableUtilities.filterSchemaColumnNamesByClass(table.getSchema(), String.class);
    }

    public static String[] getValidNumberColumnNamesInTable(Table table) throws ColumnNotFoundException {
        return TableUtilities.filterSchemaColumnNamesByClasses(table.getSchema(), POSSIBLE_NUMBER_CLASSES);
    }

    public static String[] getValidIntegerColumnNamesInTable(Table table) throws ColumnNotFoundException {
        return TableUtilities.filterSchemaColumnNamesByClasses(table.getSchema(), POSSIBLE_INTEGER_CLASSES);
    }

    public static String[] getValidDateColumnNamesInTable(Table table) throws ColumnNotFoundException {
        return TableUtilities.filterSchemaColumnNamesByClasses(table.getSchema(), POSSIBLE_DATE_CLASSES);
    }

    public static String[] filterSchemaColumnNamesByClasses(Schema schema, Class<?>[] objectClasses) throws ColumnNotFoundException {
        ArrayList<String> workingColumnNames = new ArrayList<String>();
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            Class<?>[] classArray = objectClasses;
            int n = objectClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> objectClass = classArray[n2];
                if (objectClass.isAssignableFrom(schema.getColumnType(ii))) {
                    workingColumnNames.add(schema.getColumnName(ii));
                    break;
                }
                ++n2;
            }
            ++ii;
        }
        if (workingColumnNames.size() > 0) {
            String[] finalColumnNames = new String[workingColumnNames.size()];
            return workingColumnNames.toArray(finalColumnNames);
        }
        StringBuffer objectClassesString = new StringBuffer();
        objectClassesString.append("[");
        int ii2 = 0;
        while (ii2 < objectClasses.length) {
            objectClassesString.append(objectClasses[ii2].getName());
            if (ii2 + 1 < objectClasses.length) {
                objectClassesString.append(", ");
            }
            ++ii2;
        }
        objectClassesString.append("]");
        throw new ColumnNotFoundException("No column of types " + objectClassesString + " was found.");
    }

    public static String[] filterSchemaColumnNamesByClass(Schema schema, Class<?> objectClass) throws ColumnNotFoundException {
        ArrayList<String> workingColumnNames = new ArrayList<String>();
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            if (objectClass.isAssignableFrom(schema.getColumnType(ii))) {
                workingColumnNames.add(schema.getColumnName(ii));
            }
            ++ii;
        }
        if (workingColumnNames.size() == 0) {
            throw new ColumnNotFoundException("No column of type " + objectClass.getName() + " was found.");
        }
        String[] finalColumnNames = new String[workingColumnNames.size()];
        return workingColumnNames.toArray(finalColumnNames);
    }

    public static String formNonConflictingNewColumnName(Schema schema, String suggestedColumnName) throws ColumnNotFoundException {
        List<String> workingColumnNames = TableUtilities.getAllColumnNames(schema);
        if (!workingColumnNames.contains(suggestedColumnName)) {
            return suggestedColumnName;
        }
        int columnNameSuffix = 1;
        String newColumnName;
        while (workingColumnNames.contains(newColumnName = suggestedColumnName.concat("_" + columnNameSuffix))) {
            ++columnNameSuffix;
        }
        return newColumnName;
    }

    public static String formNonConflictingNewColumnName(Schema schema, String[] suggestedColumnNames) throws ColumnNotFoundException {
        List<String> workingColumnNames = TableUtilities.getAllColumnNames(schema);
        boolean suggestedNameFound = false;
        String[] stringArray = suggestedColumnNames;
        int n = suggestedColumnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String suggestedName = stringArray[n2];
            for (String workingColumnName : workingColumnNames) {
                if (!workingColumnName.equalsIgnoreCase(suggestedName)) continue;
                suggestedNameFound = true;
                break;
            }
            if (suggestedNameFound) break;
            ++n2;
        }
        if (!suggestedNameFound) {
            return suggestedColumnNames[0];
        }
        boolean newColumnNameFound = false;
        int columnNameSuffix = 2;
        while (true) {
            String newColumnName = suggestedColumnNames[0].concat("_" + columnNameSuffix);
            for (String workingColumnName : workingColumnNames) {
                if (!workingColumnName.equalsIgnoreCase(newColumnName)) continue;
                newColumnNameFound = true;
                break;
            }
            if (!newColumnNameFound) {
                return newColumnName;
            }
            ++columnNameSuffix;
        }
    }

    public static Table createTableUsingSchema(Schema tableSchema) {
        int numTableColumns = tableSchema.getColumnCount();
        Table table = new Table();
        int ii = 0;
        while (ii < numTableColumns) {
            table.addColumn(tableSchema.getColumnName(ii), tableSchema.getColumnType(ii));
            ++ii;
        }
        return table;
    }

    public static double extractDoubleFromCell(Tuple row, String columnName) throws NumberFormatException {
        double value = NumberUtilities.interpretObjectAsDouble(row.get(columnName));
        return value;
    }

    public static Table standardizeTable(URL propertiesFilePath, Table inputTable) throws IOException {
        if (propertiesFilePath == null || inputTable == null) {
            throw new IllegalArgumentException();
        }
        Table returnTable = new Table();
        Schema oldSchema = inputTable.getSchema();
        int numTableColumns = oldSchema.getColumnCount();
        int numTableRows = inputTable.getRowCount();
        Map<String, String> headerMap = TableUtilities.readHeaderProperties(propertiesFilePath);
        int i = 0;
        while (i < numTableColumns) {
            String colHead = oldSchema.getColumnName(i);
            String newHeader = headerMap.get(colHead);
            if (newHeader != null) {
                colHead = newHeader;
            }
            returnTable.addColumn(colHead, oldSchema.getColumnType(i));
            ++i;
        }
        returnTable.addRows(numTableRows);
        i = 0;
        while (i < numTableRows) {
            TableUtilities.copyTableRow(i, i, returnTable, inputTable);
            ++i;
        }
        return returnTable;
    }

    private static Map<String, String> readHeaderProperties(URL propLocation) throws IOException {
        String extension = FilenameUtils.getExtension((String)propLocation.getPath());
        if (!extension.equals("hmap")) {
            throw new IOException("The given file extension is incompatible with this plugin. Please use a .hmap extension file instead.");
        }
        InputStream in = propLocation.openStream();
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        Properties prop = new Properties();
        try {
            prop.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String name : prop.stringPropertyNames()) {
            headerMap.put(name, prop.getProperty(name));
        }
        return headerMap;
    }
}

