/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.cishell.utilities.CollectionUtilities;
import org.cishell.utilities.FileUtilities;
import org.cishell.utilities.ZipIOException;

@Deprecated
public class ZipUtilities {
    static final int BUFFER_SIZE = 2048;

    public static void zipFiles(Collection<File> files, ZipOutputStream zipOut) throws ZipIOException {
        try {
            try {
                for (File file : files) {
                    ZipUtilities.writeFileToZipFile(file, file.getName(), zipOut);
                }
                zipOut.close();
            }
            catch (IOException e) {
                throw new ZipIOException(e.getMessage(), e);
            }
        }
        finally {
            try {
                zipOut.close();
            }
            catch (IOException e) {
                throw new ZipIOException(e.getMessage(), e);
            }
        }
    }

    public static void zipFiles(Collection<File> files, File targetZipFile) throws ZipIOException {
        try {
            ZipUtilities.zipFiles(files, new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetZipFile))));
        }
        catch (FileNotFoundException e) {
            throw new ZipIOException(e.getMessage(), e);
        }
    }

    public static void zipFilesWithNames(Map<File, String> fileToZippedName, ZipOutputStream zipOut) throws ZipIOException {
        try {
            try {
                for (File file : fileToZippedName.keySet()) {
                    ZipUtilities.writeFileToZipFile(file, fileToZippedName.get(file), zipOut);
                }
                zipOut.close();
            }
            catch (IOException e) {
                throw new ZipIOException(e.getMessage(), e);
            }
        }
        finally {
            try {
                zipOut.close();
            }
            catch (IOException e) {
                throw new ZipIOException(e.getMessage(), e);
            }
        }
    }

    public static void zipFilesWithNames(Map<File, String> fileToZippedName, File targetZipFile) throws ZipIOException {
        try {
            ZipUtilities.zipFilesWithNames(fileToZippedName, new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetZipFile))));
        }
        catch (FileNotFoundException e) {
            throw new ZipIOException(e.getMessage(), e);
        }
    }

    public static void writeFileToZipFile(File file, String zippedName, ZipOutputStream zipOut) throws ZipIOException {
        try {
            int count;
            byte[] data = new byte[2048];
            BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(file), 2048);
            ZipEntry entry = new ZipEntry(zippedName);
            zipOut.putNextEntry(entry);
            while ((count = fileInput.read(data, 0, 2048)) != -1) {
                zipOut.write(data, 0, count);
            }
            fileInput.close();
        }
        catch (FileNotFoundException e) {
            throw new ZipIOException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ZipIOException(e.getMessage(), e);
        }
    }

    public static File readFileFromZipFile(ZipEntry entry, ZipFile zipFile) throws IOException {
        long size = entry.getSize();
        if (size > 0L) {
            int readByteCount;
            BufferedInputStream reader = new BufferedInputStream(zipFile.getInputStream(entry));
            String fileName = new File(entry.getName()).getName();
            File outputFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory(fileName, "tmp");
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile), 2048);
            byte[] readBytes = new byte[2048];
            while ((readByteCount = reader.read(readBytes, 0, 2048)) != -1) {
                output.write(readBytes, 0, readByteCount);
            }
            output.close();
            return outputFile;
        }
        return null;
    }

    public static Map<String, ZipEntry> mapFileNamesToEntries(ZipFile zipFile, boolean includeDirectories) throws IOException {
        Collection<ZipEntry> entries = ZipUtilities.collectEntries(zipFile);
        HashMap<String, ZipEntry> fileNamesToEntries = new HashMap<String, ZipEntry>();
        for (ZipEntry entry : entries) {
            if (includeDirectories) {
                if (!entry.isDirectory()) continue;
                fileNamesToEntries.put(entry.getName(), entry);
                continue;
            }
            if (entry.isDirectory()) continue;
            fileNamesToEntries.put(entry.getName(), entry);
        }
        return fileNamesToEntries;
    }

    public static Collection<ZipEntry> collectEntries(ZipFile zipFile) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        return CollectionUtilities.collectionEnumerationElements(entries, new ArrayList());
    }
}

