/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities.database;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cishell.utilities.DatabaseUtilities;
import org.cishell.utilities.StringUtilities;
import org.cishell.utilities.database.ColumnPair;
import org.cishell.utilities.database.ForeignKey;
import org.cishell.utilities.database.ForeignKeyNameWithTable;
import org.cishell.utilities.database.InvalidRepresentationException;
import org.cishell.utilities.database.Remover;

@Deprecated
public final class DatabaseTable {
    public final String catalog;
    public final String schema;
    public final String name;

    public DatabaseTable(String catalog, String schema, String name) {
        this.catalog = catalog == null ? "" : catalog.intern();
        this.schema = schema == null ? "" : schema.intern();
        this.name = name == null ? "" : name.intern();
    }

    public static DatabaseTable fromRepresentation(String representation) throws InvalidRepresentationException {
        String[] parts = representation.split("\\.");
        switch (parts.length) {
            case 1: {
                return new DatabaseTable(null, null, parts[0]);
            }
            case 2: {
                return new DatabaseTable(null, parts[0], parts[1]);
            }
            case 3: {
                return new DatabaseTable(parts[0], parts[1], parts[2]);
            }
        }
        throw new InvalidRepresentationException("The representation '" + representation + "' has the wrong number of parts!");
    }

    public static DatabaseTable[] availableTables(Connection connection) throws SQLException {
        ResultSet results = connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
        ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>();
        while (results.next()) {
            tables.add(new DatabaseTable(results.getString(1), results.getString(2), results.getString(3)));
        }
        results.close();
        return tables.toArray(new DatabaseTable[0]);
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        if (this.catalog != null && this.catalog != "") {
            output.append(this.catalog);
            output.append('.');
        }
        if (this.schema != null && this.schema != "") {
            output.append(this.schema);
            output.append('.');
        }
        output.append(this.name);
        return output.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DatabaseTable)) {
            return false;
        }
        DatabaseTable o = (DatabaseTable)other;
        return o.catalog == this.catalog && o.schema == this.schema && o.name == this.name;
    }

    public int hashCode() {
        int hash = this.catalog.hashCode() * 7;
        hash += this.schema.hashCode() * 5;
        return hash += this.name.hashCode() * 3;
    }

    public boolean presentInDatabase(Connection connection) throws SQLException {
        ResultSet results = connection.getMetaData().getTables(this.catalog, this.schema, this.name, new String[]{"TABLE"});
        boolean foundOne = results.next();
        results.close();
        return foundOne;
    }

    public boolean hasPrimaryKey(Connection connection) throws SQLException {
        return this.getPrimaryKeyColumns(connection).length != 0;
    }

    public ForeignKey[] getRelations(Connection connection) throws SQLException {
        ResultSet related = connection.getMetaData().getExportedKeys(this.catalog, this.schema, this.name);
        HashMap<ForeignKeyNameWithTable, Set<ColumnPair>> correspondences = new HashMap<ForeignKeyNameWithTable, Set<ColumnPair>>();
        while (related.next()) {
            String foreignKeyName = related.getString(12);
            DatabaseTable relatedTable = new DatabaseTable(related.getString(5), related.getString(6), related.getString(7));
            ForeignKeyNameWithTable key = new ForeignKeyNameWithTable(foreignKeyName, relatedTable);
            ColumnPair pair = new ColumnPair(related.getString(4), related.getString(8));
            if (!correspondences.containsKey(key)) {
                correspondences.put(key, new HashSet());
            }
            ((Set)correspondences.get(key)).add(pair);
        }
        related.close();
        return this.makeForeignKeys(correspondences);
    }

    private ForeignKey[] makeForeignKeys(Map<ForeignKeyNameWithTable, Set<ColumnPair>> correspondences) {
        ForeignKey[] foreignKeys = new ForeignKey[correspondences.size()];
        int index = 0;
        for (Map.Entry<ForeignKeyNameWithTable, Set<ColumnPair>> entry : correspondences.entrySet()) {
            foreignKeys[index] = new ForeignKey(this, entry.getKey().table, entry.getValue());
            ++index;
        }
        return foreignKeys;
    }

    public String[] getPrimaryKeyColumns(Connection connection) throws SQLException {
        ResultSet columns = connection.getMetaData().getPrimaryKeys(this.catalog, this.schema, this.name);
        ArrayList<String> columnNames = new ArrayList<String>();
        while (columns.next()) {
            columnNames.add(columns.getString(4));
        }
        return columnNames.toArray(new String[0]);
    }

    public void deleteRowsByColumns(List<Map<String, Object>> otherEntities, Statement statement) throws SQLException {
        if (otherEntities.size() == 0) {
            return;
        }
        ArrayList<String> columns = new ArrayList<String>(otherEntities.get(0).keySet());
        String deleteStatement = this.constructDeleteStatement(columns, otherEntities);
        statement.addBatch(deleteStatement);
    }

    private String constructDeleteStatement(List<String> columns, List<Map<String, Object>> otherEntities) {
        return "DELETE FROM " + this.toString() + " WHERE " + DatabaseUtilities.createSQLInExpression(columns, otherEntities);
    }

    private String formatDeleteEquals(Connection connection, String separator) throws SQLException {
        String[] primaryKeys;
        TreeSet keys = Sets.newTreeSet();
        String[] stringArray = primaryKeys = this.getPrimaryKeyColumns(connection);
        int n = primaryKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            keys.add(String.valueOf(key) + " = ?");
            ++n2;
        }
        return StringUtilities.implodeItems(Lists.newArrayList((Iterable)keys), separator);
    }

    public Remover constructRemover(Connection connection) throws SQLException {
        String deleteSql = "DELETE FROM " + this.toString() + " WHERE " + this.formatDeleteEquals(connection, " AND ");
        final PreparedStatement statement = connection.prepareStatement(deleteSql);
        return new Remover(){

            @Override
            public void remove(Map<String, Object> values) throws SQLException {
                int index = 1;
                for (Object value : ImmutableSortedMap.copyOf(values).values()) {
                    statement.setObject(index, value);
                    ++index;
                }
                statement.addBatch();
            }

            @Override
            public int apply() throws SQLException {
                int removed = 0;
                int[] updates = statement.executeBatch();
                int ii = 0;
                while (ii < updates.length) {
                    removed += updates[ii];
                    ++ii;
                }
                return removed;
            }
        };
    }
}

