/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities.database;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cishell.utilities.StringUtilities;
import org.cishell.utilities.database.ColumnPair;
import org.cishell.utilities.database.DatabaseTable;
import org.cishell.utilities.database.Repointer;

@Deprecated
public final class ForeignKey {
    public final DatabaseTable localTable;
    public final DatabaseTable otherTable;
    public final Set<ColumnPair> pairs;

    public ForeignKey(DatabaseTable localTable, DatabaseTable otherTable, Set<ColumnPair> pairs) {
        this.localTable = localTable;
        this.otherTable = otherTable;
        this.pairs = ImmutableSet.copyOf(pairs);
    }

    private Map<String, Object> translateToForeignNames(Map<String, Object> from) {
        TreeMap to = Maps.newTreeMap();
        for (ColumnPair pair : this.pairs) {
            to.put(pair.foreign, from.get(pair.local));
        }
        return to;
    }

    private List<String> getForeignColumnNames() {
        ArrayList<String> foreignColumns = new ArrayList<String>();
        for (ColumnPair pair : this.pairs) {
            foreignColumns.add(pair.foreign);
        }
        return foreignColumns;
    }

    private String formatUpdateEquals(String separator) {
        TreeSet updateStatements = Sets.newTreeSet();
        for (ColumnPair pair : this.pairs) {
            String foreignColumn = pair.foreign;
            updateStatements.add(String.valueOf(foreignColumn) + " = ?");
        }
        return StringUtilities.implodeItems(Lists.newArrayList((Iterable)updateStatements), separator);
    }

    public Repointer constructRepointer(Connection connection) throws SQLException {
        final PreparedStatement statement = connection.prepareStatement("UPDATE " + this.otherTable.toString() + " SET " + this.formatUpdateEquals(", ") + " WHERE " + this.formatUpdateEquals(" AND "));
        return new Repointer(){

            @Override
            public void repoint(Map<String, Object> primary, Map<String, Object> secondary) throws SQLException {
                int index = 1;
                for (Object primaryValue : primary.values()) {
                    statement.setObject(index, primaryValue);
                    ++index;
                }
                for (Object secondaryValue : secondary.values()) {
                    statement.setObject(index, secondaryValue);
                    ++index;
                }
                statement.addBatch();
            }

            @Override
            public void apply() throws SQLException {
                statement.executeBatch();
            }
        };
    }
}

