/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities.logging;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.cishell.utilities.logging.MessageType;
import org.cishell.utilities.logging.PrintStreamLogger;
import org.osgi.service.log.LogService;

@Deprecated
public class LogMessageHandler {
    private LogService logger;
    private Set<MessageType> messageTypes = new HashSet<MessageType>();

    public LogMessageHandler() {
        this.logger = new PrintStreamLogger();
    }

    public LogMessageHandler(PrintStream out) {
        Preconditions.checkNotNull((Object)out);
        this.logger = new PrintStreamLogger(out);
    }

    public LogMessageHandler(LogService logger) {
        Preconditions.checkNotNull((Object)logger);
        this.logger = logger;
    }

    public MessageType addMessageType(String description, int maximumCount, int logLevel) {
        MessageType messageType = new MessageType(description, maximumCount, logLevel);
        this.messageTypes.add(messageType);
        return messageType;
    }

    public void handleMessage(MessageType messageType, String message) {
        this.handleMessage(messageType, messageType.getLogLevel(), message);
    }

    private void handleMessage(MessageType messageType, int logLevel, String message) {
        Preconditions.checkNotNull((Object)messageType);
        messageType.reportMessageReceived();
        if (messageType.shouldStillLog()) {
            this.logger.log(logLevel, message);
        }
    }

    public void printOverLimitMessageTypes() {
        for (MessageType messageType : this.messageTypes) {
            this.printOverLimitMessage(messageType, messageType.getLogLevel());
        }
    }

    public void printOverLimitMessageTypes(int logLevelOverride) {
        for (MessageType messageType : this.messageTypes) {
            this.printOverLimitMessage(messageType, logLevelOverride);
        }
    }

    private void printOverLimitMessage(MessageType messageType, int logLevel) {
        if (messageType.messagesOverLimit() > 0) {
            this.logger.log(messageType.getLogLevel(), LogMessageHandler.getOverLimitMessage(messageType));
        }
    }

    private static String getOverLimitMessage(MessageType messageType) {
        return String.valueOf(messageType.messagesOverLimit()) + " additional messages about " + messageType.getDescription() + " were filtered.";
    }
}

