/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utilities.network;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;

@Deprecated
public final class DownloadHandler {
    public static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    public static final int BUFFER_SIZE = 4096;

    private DownloadHandler() {
    }

    public static String getResponse(HttpURLConnection connection, int numberOfRetries) throws IOException, InvalidUrlException, NetworkConnectionException {
        int size;
        DownloadHandler.startConnect(connection, numberOfRetries);
        InputStream inputStream = connection.getInputStream();
        StringBuilder response = new StringBuilder();
        byte[] buffer = new byte[4096];
        while ((size = inputStream.read(buffer)) != -1) {
            response.append(new String(buffer, 0, size));
        }
        connection.disconnect();
        return response.toString();
    }

    public static String getResponse(HttpURLConnection connection) throws IOException, InvalidUrlException, NetworkConnectionException {
        return DownloadHandler.getResponse(connection, 3);
    }

    public static String getResponse(URL url, int numberOfRetries) throws IOException, InvalidUrlException, NetworkConnectionException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        return DownloadHandler.getResponse(connection, numberOfRetries);
    }

    public static String getResponse(URL url) throws IOException, InvalidUrlException, NetworkConnectionException {
        return DownloadHandler.getResponse(url, 3);
    }

    public static void startConnect(HttpURLConnection connection) throws InvalidUrlException, NetworkConnectionException {
        DownloadHandler.startConnect(connection, 3);
    }

    public static void startConnect(HttpURLConnection connection, int numberOfRetries) throws InvalidUrlException, NetworkConnectionException {
        if (numberOfRetries < 0) {
            throw new IllegalArgumentException("numberOfRetries must be more than 0.");
        }
        int retry = numberOfRetries;
        while (retry > 0) {
            try {
                connection.connect();
                break;
            }
            catch (IOException e) {
                connection.disconnect();
                if (--retry != 0) continue;
                if (e instanceof SocketTimeoutException) {
                    throw new NetworkConnectionException("Failed to connect to " + connection.getURL() + ". The host or your local network connection is too weak.", e);
                }
                throw new InvalidUrlException("Failed to connect to " + connection.getURL() + ". Please valify the URL.", e);
            }
        }
    }

    public static class InvalidUrlException
    extends Exception {
        private static final long serialVersionUID = -5974867330254562053L;

        public InvalidUrlException(String message, Throwable reason) {
            super(message, reason);
        }
    }

    public static class NetworkConnectionException
    extends Exception {
        private static final long serialVersionUID = -7623325107609518773L;

        public NetworkConnectionException(String message, Throwable reason) {
            super(message, reason);
        }
    }
}

