/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.datastructure.datamodel.area;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cishell.utility.datastructure.datamodel.area.DataModelArea;
import org.cishell.utility.datastructure.datamodel.exception.ModelStructureException;
import org.cishell.utility.datastructure.datamodel.exception.UniqueNameException;
import org.cishell.utility.datastructure.datamodel.field.DataModelField;

public abstract class AbstractDataModelArea<BaseGUIComponentType, GUIContainerComponentType extends BaseGUIComponentType>
implements DataModelArea {
    private DataModelArea parentArea;
    private GUIContainerComponentType parentComponent;
    private String name;
    private Map<String, DataModelArea> areas = new HashMap<String, DataModelArea>();
    private Map<String, DataModelField<?>> fields = new HashMap();

    public AbstractDataModelArea(DataModelArea parentArea, GUIContainerComponentType parentComponent, String name) {
        this.parentArea = parentArea;
        this.parentComponent = parentComponent;
        this.name = name;
    }

    @Override
    public DataModelArea getParentArea() {
        return this.parentArea;
    }

    @Override
    public Object getParentComponent() {
        return this.parentComponent;
    }

    public GUIContainerComponentType getParentComponentWithType() {
        return this.parentComponent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getAreaNames() {
        return this.areas.keySet();
    }

    @Override
    public Collection<DataModelArea> getAreas() {
        return this.areas.values();
    }

    @Override
    public DataModelArea getArea(String name) {
        return this.areas.get(name);
    }

    @Override
    public DataModelArea createArea(String name) throws UniqueNameException {
        if (this.getArea(name) != null) {
            String exceptionMessage = String.format("The area '%s' already exists.  All areas must have unique names.", name);
            throw new UniqueNameException(exceptionMessage);
        }
        DataModelArea area = this.internalCreateArea(name);
        this.areas.put(name, area);
        return area;
    }

    @Override
    public abstract DataModelArea createArea(String var1, Object var2) throws ClassCastException, ModelStructureException, UniqueNameException;

    protected abstract DataModelArea internalCreateArea(String var1);

    @Override
    public void addArea(DataModelArea area) throws ClassCastException, ModelStructureException, UniqueNameException {
        String name = area.getName();
        if (this.getArea(name) != null) {
            String exceptionMessage = String.format("The area '%s' already exists.  All areas must have unique names.", name);
            throw new UniqueNameException(exceptionMessage);
        }
        if (area.getParentComponent() != this.getParentComponent()) {
            String exceptionMessage = String.format("Tried to manually add area %s to area %s, but parent components do not match.", name, this.getName());
            throw new ModelStructureException(exceptionMessage);
        }
        this.areas.put(name, area);
    }

    @Override
    public boolean areaDisposed(String name) {
        if (this.areas.containsKey(name)) {
            this.areas.remove(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean areaDisposed(DataModelArea area) {
        return this.areaDisposed(area.getName());
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public Collection<DataModelField<?>> getFields() {
        return this.fields.values();
    }

    @Override
    public DataModelField<?> getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    @Override
    public <T> void addField(DataModelField<T> field) throws UniqueNameException {
        String fieldName = field.getName();
        if (this.getField(fieldName) != null) {
            String format = "The field '%s' already exists in this area (%s).  All fields must have unique names.";
            String exceptionMessage = String.format(format, fieldName, this.name);
            throw new UniqueNameException(exceptionMessage);
        }
        this.fields.put(fieldName, field);
        field.addToContainer(this);
    }

    @Override
    public boolean fieldDisposed(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            this.fields.remove(fieldName);
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean fieldDisposed(DataModelField<T> field) {
        return this.fieldDisposed(field.getName());
    }
}

