/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.datastructure.datamodel.field.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.cishell.utility.datastructure.datamodel.DataModel;
import org.cishell.utility.datastructure.datamodel.exception.ModelValidationException;
import org.cishell.utility.datastructure.datamodel.field.DataModelField;
import org.cishell.utility.datastructure.datamodel.field.validation.FieldValidationRule;
import org.cishell.utility.datastructure.datamodel.field.validation.FieldValidator;

public class BasicFieldValidator<ValueType>
implements FieldValidator<ValueType> {
    private String baseFieldName;
    private Collection<DataModelField<ValueType>> fieldsToValidate = new HashSet<DataModelField<ValueType>>();
    private Collection<FieldValidationRule<ValueType>> rules = new HashSet<FieldValidationRule<ValueType>>();

    public BasicFieldValidator(String baseFieldName) {
        this.baseFieldName = baseFieldName;
    }

    @Override
    public void addFieldToValidate(DataModelField<ValueType> field) {
        this.fieldsToValidate.add(field);
    }

    @Override
    public void addValidationRule(FieldValidationRule<ValueType> rule) {
        this.rules.add(rule);
    }

    @Override
    public Collection<String> runValidation(DataModel model) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (DataModelField<ValueType> field : this.fieldsToValidate) {
            String errorHeader = String.format("(%s%s, %s): ", this.baseFieldName, field.getName(), field.getValue().toString());
            for (FieldValidationRule<ValueType> rule : this.rules) {
                try {
                    rule.validateField(field, model);
                }
                catch (ModelValidationException e) {
                    String errorMessage = String.valueOf(errorHeader) + e.getMessage();
                    errorMessages.add(errorMessage);
                }
            }
        }
        return errorMessages;
    }

    @Override
    public void fieldUpdated(DataModelField<ValueType> field) {
        for (FieldValidationRule<ValueType> rule : this.rules) {
            rule.fieldUpdated(field);
        }
    }

    @Override
    public void fieldsUpdated(Collection<DataModelField<ValueType>> fields) {
        for (FieldValidationRule<ValueType> rule : this.rules) {
            rule.fieldsUpdated(fields);
        }
    }

    @Override
    public void fieldDisposed(DataModelField<ValueType> field) {
        for (FieldValidationRule<ValueType> rule : this.rules) {
            rule.fieldDisposed(field);
        }
        this.fieldsToValidate.remove(field);
    }
}

