/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.datastructure.datamodel.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cishell.utility.datastructure.datamodel.exception.UniqueNameException;
import org.cishell.utility.datastructure.datamodel.field.DataModelField;
import org.cishell.utility.datastructure.datamodel.group.DataModelGroup;

public class BasicModelGroup
implements DataModelGroup {
    private String name;
    private Map<String, DataModelField<?>> fields = new HashMap();

    public BasicModelGroup(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public Collection<DataModelField<?>> getFields() {
        ArrayList fields = new ArrayList();
        fields.addAll(this.fields.values());
        return fields;
    }

    @Override
    public DataModelField<?> getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public <T> void addField(DataModelField<T> field) throws ClassCastException, UniqueNameException {
        String fieldName = field.getName();
        if (this.fields.containsKey(fieldName)) {
            String format = "The field '%s' already exists in this group (%s).  All fields must have unique names.";
            String exceptionMessage = String.format(format, fieldName, this.name);
            throw new UniqueNameException(exceptionMessage);
        }
        this.fields.put(fieldName, field);
        field.addToContainer(this);
    }

    @Override
    public boolean fieldDisposed(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            this.fields.remove(fieldName);
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean fieldDisposed(DataModelField<T> field) {
        return this.fieldDisposed(field.getName());
    }
}

