/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.datastructure.datamodel.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cishell.utility.datastructure.datamodel.DataModel;
import org.cishell.utility.datastructure.datamodel.area.DataModelArea;
import org.cishell.utility.datastructure.datamodel.exception.ModelStructureException;
import org.cishell.utility.datastructure.datamodel.exception.UniqueNameException;
import org.cishell.utility.datastructure.datamodel.field.DataModelField;
import org.cishell.utility.datastructure.datamodel.group.BasicModelGroup;
import org.cishell.utility.datastructure.datamodel.group.DataModelGroup;

public abstract class AbstractGUIDataModel<BaseGUIComponentType, GUIContainerComponentType extends BaseGUIComponentType>
implements DataModel {
    private Map<String, DataModelArea> areas = new HashMap<String, DataModelArea>();
    private Map<String, DataModelGroup> groups = new HashMap<String, DataModelGroup>();
    private GUIContainerComponentType currentParentComponent;

    @Override
    public void setCurrentParentComponent(Object currentParentComponent) throws ClassCastException {
        this.currentParentComponent = currentParentComponent;
    }

    public GUIContainerComponentType getCurrentParentComponent() {
        return this.currentParentComponent;
    }

    @Override
    public Collection<String> getAreaNames() {
        return this.areas.keySet();
    }

    @Override
    public Collection<DataModelArea> getAreas() {
        return this.areas.values();
    }

    @Override
    public DataModelArea getArea(String name) {
        return this.areas.get(name);
    }

    @Override
    public DataModelArea createArea(String name) throws UniqueNameException {
        if (this.getArea(name) != null) {
            String exceptionMessage = String.format("The area '%s' already exists.  All areas must have unique names.", name);
            throw new UniqueNameException(exceptionMessage);
        }
        DataModelArea area = this.createGUISpecificArea(name);
        this.areas.put(name, area);
        return area;
    }

    @Override
    public abstract DataModelArea createArea(String var1, Object var2) throws ClassCastException, ModelStructureException, UniqueNameException;

    protected abstract DataModelArea createGUISpecificArea(String var1);

    @Override
    public void addArea(DataModelArea area) throws ClassCastException, ModelStructureException, UniqueNameException {
        String name = area.getName();
        if (this.getArea(name) != null) {
            String exceptionMessage = String.format("The area '%s' already exists.  All areas must have unique names.", name);
            throw new UniqueNameException(exceptionMessage);
        }
        this.areas.put(name, area);
    }

    @Override
    public boolean areaDisposed(String name) {
        if (this.areas.containsKey(name)) {
            this.areas.remove(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean areaDisposed(DataModelArea area) {
        return this.areaDisposed(area.getName());
    }

    @Override
    public Collection<String> getGroupNames() {
        return this.groups.keySet();
    }

    @Override
    public Collection<DataModelGroup> getGroups() {
        return this.groups.values();
    }

    @Override
    public DataModelGroup getGroup(String name) {
        return this.groups.get(name);
    }

    @Override
    public DataModelGroup createGroup(String name) throws UniqueNameException {
        if (this.getGroup(name) != null) {
            String exceptionMessage = String.format("The group '%s' already exists.  All groups must have unique names.", name);
            throw new UniqueNameException(exceptionMessage);
        }
        BasicModelGroup group = new BasicModelGroup(name);
        this.groups.put(name, group);
        return group;
    }

    @Override
    public abstract DataModelField<Boolean> addCheckBox(String var1, String var2, String var3, boolean var4) throws UniqueNameException;

    @Override
    public abstract <T> DataModelField<T> addDropDown(String var1, String var2, String var3, int var4, Collection<String> var5, Map<String, T> var6) throws UniqueNameException;

    @Override
    public abstract <T> DataModelField<T> addList(String var1, String var2, String var3, int var4, Collection<String> var5, Map<String, T> var6) throws UniqueNameException;

    @Override
    public abstract DataModelField<String> addText(String var1, String var2, String var3, String var4, boolean var5) throws UniqueNameException;

    @Override
    public abstract <T> void addField(String var1, String var2, DataModelField<T> var3) throws UniqueNameException;
}

