/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.dict;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.cishell.utility.dict.IteratorEnumeration;

public class ImmutableDictionary<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    private final ImmutableMap<K, V> delegate;

    private ImmutableDictionary(Map<? extends K, ? extends V> source) {
        this.delegate = ImmutableMap.copyOf(source);
    }

    public static <K, V> ImmutableDictionary<K, V> fromMap(Map<? extends K, ? extends V> map) {
        return new ImmutableDictionary<K, V>(map);
    }

    public static <K, V> ImmutableDictionary<K, V> fromDictionary(Dictionary<? extends K, ? extends V> dict) {
        if (dict instanceof Map) {
            ImmutableDictionary<K, V> ret = ImmutableDictionary.fromMap((Map)((Object)dict));
            return ret;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Enumeration<K> keys = dict.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            builder.put(key, dict.get(key));
        }
        return new ImmutableDictionary<K, V>(builder.build());
    }

    public static <K, V> ImmutableDictionary<K, V> of() {
        return ImmutableDictionary.fromMap(ImmutableMap.of());
    }

    public static <K, V> ImmutableDictionary<K, V> of(K k1, V v1) {
        return ImmutableDictionary.fromMap(ImmutableMap.of(k1, v1));
    }

    public static <K, V> ImmutableDictionary<K, V> of(K k1, V v1, K k2, V v2) {
        return ImmutableDictionary.fromMap(ImmutableMap.of(k1, v1, k2, v2));
    }

    public static <K, V> ImmutableDictionary<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableDictionary.fromMap(ImmutableMap.of(k1, v1, k2, v2, k3, v3));
    }

    public static <K, V> ImmutableDictionary<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableDictionary.fromMap(ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4));
    }

    public static <K, V> ImmutableDictionary<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableDictionary.fromMap(ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
    }

    @Override
    public final V put(K k, V v) {
        return (V)this.delegate.put(k, v);
    }

    @Override
    public final V remove(Object o) {
        return (V)this.delegate.remove(o);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    @Override
    public final void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public ImmutableCollection<V> values() {
        return this.delegate.values();
    }

    @Override
    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Enumeration<V> elements() {
        return new IteratorEnumeration(this.delegate.values().iterator());
    }

    @Override
    public Enumeration<K> keys() {
        return new IteratorEnumeration(this.delegate.keySet().iterator());
    }
}

