/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cishell.utility.swt.GUIBuilderUtilities;
import org.cishell.utility.swt.GridContainer;
import org.cishell.utility.swt.ScrolledComponentFactory;
import org.cishell.utility.swt.WidgetConstructionException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExpandableComponentWidget<T>
extends Composite {
    public static final int COLUMN_AREA_LAYOUT_VERTICAL_SPACING = 1;
    public static final int VERTICAL_SCROLL_INCREMENT = 50;
    private ScrolledComponentFactory<T> componentFactory;
    private Composite headerArea;
    private ScrolledComposite scrollingArea;
    private GridContainer scrolledAreaGrid;
    private Composite footerArea;
    private List<T> components = new ArrayList<T>();
    private int uniqueComponentCount = 0;
    private Collection<Label> columnLabels;

    public ExpandableComponentWidget(Composite parent, ScrolledComponentFactory<T> componentFactory) {
        super(parent, 0);
        this.componentFactory = componentFactory;
        this.setLayout((Layout)ExpandableComponentWidget.createLayout());
        this.headerArea = this.createHeaderArea();
        this.scrollingArea = this.createScrollingArea();
        this.footerArea = this.createFooterArea();
        this.scrolledAreaGrid = this.createScrolledAreaGrid((Composite)this.scrollingArea);
        this.scrollingArea.setExpandHorizontal(true);
        this.scrollingArea.setExpandVertical(true);
        this.scrollingArea.setAlwaysShowScrollBars(true);
        this.fixSize();
        this.scrollingArea.setContent((Control)this.scrolledAreaGrid.getActualParent());
        this.scrollingArea.getVerticalBar().setPageIncrement(50);
        this.columnLabels = this.createColumnLabels(this.scrolledAreaGrid.getActualParent(), 0);
    }

    public Composite getHeaderArea() {
        return this.headerArea;
    }

    public Composite getFooterArea() {
        return this.footerArea;
    }

    public List<T> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public int getColumnCount() {
        return 1;
    }

    public T addComponent(int style, Map<String, Object> arguments) throws WidgetConstructionException {
        if (this.components.size() == 0) {
            for (Label columnLabel : this.columnLabels) {
                columnLabel.setVisible(true);
            }
        }
        int componentCount = this.components.size();
        T component = this.componentFactory.constructWidget(this, this.scrolledAreaGrid, style, arguments, componentCount, this.uniqueComponentCount);
        ++this.uniqueComponentCount;
        this.fixSize();
        this.components.add(component);
        return component;
    }

    public void removeComponent(int index) {
        this.scrolledAreaGrid.removeRow(index);
        this.components.remove(index);
        this.fixSize();
        int ii = 0;
        while (ii < this.components.size()) {
            this.componentFactory.reindexComponent(this.components.get(ii), ii);
            ++ii;
        }
        if (this.components.size() == 0) {
            for (Label columnLabel : this.columnLabels) {
                columnLabel.setVisible(false);
            }
        }
    }

    public Collection<Label> createColumnLabels(Composite parent, int style) {
        ArrayList<Label> columnLabels = new ArrayList<Label>();
        for (String columnLabelText : this.createColumnLabelTexts()) {
            Label columnLabel = new Label(parent, style);
            columnLabel.setLayoutData((Object)this.createColumnLabelLayoutData());
            columnLabel.setText(columnLabelText);
            columnLabels.add(columnLabel);
        }
        return columnLabels;
    }

    public Collection<String> createColumnLabelTexts() {
        ArrayList<String> columnLabelTexts = new ArrayList<String>();
        int ii = 0;
        while (ii < this.getColumnCount()) {
            columnLabelTexts.add("Column " + ii);
            ++ii;
        }
        return columnLabelTexts;
    }

    private void fixSize() {
        Composite scrolledArea = this.scrolledAreaGrid.getActualParent();
        this.scrollingArea.setMinSize(scrolledArea.computeSize(-1, -1));
        scrolledArea.pack();
    }

    protected Composite createHeaderArea() {
        Composite headerArea = new Composite((Composite)this, 0);
        headerArea.setLayoutData((Object)this.createHeaderAreaLayoutData());
        headerArea.setLayout((Layout)this.createHeaderLayout());
        return headerArea;
    }

    protected GridData createHeaderAreaLayoutData() {
        GridData layoutData = new GridData(4, 128, true, false);
        return layoutData;
    }

    protected GridLayout createHeaderLayout() {
        GridLayout layout = new GridLayout(1, false);
        GUIBuilderUtilities.clearMargins(layout);
        GUIBuilderUtilities.clearSpacing(layout);
        return layout;
    }

    protected ScrolledComposite createScrollingArea() {
        ScrolledComposite scrollingArea = new ScrolledComposite((Composite)this, 2560);
        scrollingArea.setLayoutData((Object)this.createScrollingAreaLayoutData());
        scrollingArea.setLayout((Layout)this.createScrollingLayout());
        return scrollingArea;
    }

    protected GridData createScrollingAreaLayoutData() {
        GridData layoutData = new GridData(4, 4, true, true);
        return layoutData;
    }

    private GridLayout createScrollingLayout() {
        GridLayout layout = new GridLayout(1, true);
        GUIBuilderUtilities.clearMargins(layout);
        GUIBuilderUtilities.clearSpacing(layout);
        return layout;
    }

    protected Composite createFooterArea() {
        Composite footerArea = new Composite((Composite)this, 2048);
        footerArea.setLayoutData((Object)this.createFooterAreaLayoutData());
        footerArea.setLayout((Layout)this.createFooterLayout());
        return footerArea;
    }

    protected GridData createFooterAreaLayoutData() {
        GridData layoutData = new GridData(4, 128, true, false);
        return layoutData;
    }

    protected GridLayout createFooterLayout() {
        GridLayout layout = new GridLayout(1, false);
        GUIBuilderUtilities.clearMargins(layout);
        GUIBuilderUtilities.clearSpacing(layout);
        return layout;
    }

    private GridContainer createScrolledAreaGrid(Composite parent) {
        Composite columnArea = new Composite(parent, 0);
        columnArea.setLayoutData((Object)this.createScrolledAreaLayoutData());
        int columnCount = this.getColumnCount();
        columnArea.setLayout((Layout)this.createScrolledAreaLayout(columnCount));
        return new GridContainer(columnArea, columnCount);
    }

    protected GridData createScrolledAreaLayoutData() {
        GridData layoutData = new GridData(4, 4, true, true);
        return layoutData;
    }

    protected GridLayout createScrolledAreaLayout(int columnCount) {
        GridLayout layout = new GridLayout(columnCount, false);
        return layout;
    }

    protected GridData createColumnLabelLayoutData() {
        GridData layoutData = new GridData(0x1000000, 0x1000000, false, false);
        return layoutData;
    }

    protected GridData createComponentLayoutData() {
        GridData layoutData = new GridData(4, 128, true, false);
        return layoutData;
    }

    private static GridLayout createLayout() {
        GridLayout layout = new GridLayout(1, true);
        GUIBuilderUtilities.clearMargins(layout);
        GUIBuilderUtilities.clearSpacing(layout);
        return layout;
    }
}

