/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt;

import org.cishell.utility.datastructure.ObjectContainer;
import org.cishell.utility.swt.GUICanceledException;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GUIBuilderUtilities {
    public static Display createDisplay() {
        return new Display();
    }

    public static Shell createShell(Display display, String windowTitle, int windowWidth, int windowHeight, int columnCount, boolean clearSpacing) {
        Shell shell = new Shell(display, 224);
        shell.setText(windowTitle);
        shell.setSize(windowWidth, windowHeight);
        shell.setLayout((Layout)GUIBuilderUtilities.createShellLayout(columnCount, clearSpacing));
        return shell;
    }

    public static GridLayout createShellLayout(int columnCount, boolean clearSpacing) {
        GridLayout layout = new GridLayout(columnCount, true);
        if (clearSpacing) {
            GUIBuilderUtilities.clearSpacing(layout);
        }
        return layout;
    }

    public static void openShell(Shell shell, int windowHeight, boolean useWindowHeightToSizeShell) {
        shell.pack();
        shell.open();
        if (useWindowHeightToSizeShell) {
            Point shellSize = shell.computeSize(-1, -1);
            shell.setSize(shell.getSize().x, Math.min(windowHeight, shellSize.y));
        }
    }

    public static void swtLoop(Display display, Shell shell) {
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void clearMargins(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
    }

    public static void clearSpacing(GridLayout layout) {
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
    }

    public static void setCancelable(final Shell shell, final ObjectContainer<GUICanceledException> exceptionThrown) {
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        shell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent event) {
            }

            public void shellClosed(ShellEvent event) {
                if (exceptionThrown != null) {
                    String exceptionMessage = "Canceled by user.";
                    exceptionThrown.object = new GUICanceledException(exceptionMessage);
                }
            }

            public void shellDeactivated(ShellEvent event) {
            }

            public void shellDeiconified(ShellEvent event) {
            }

            public void shellIconified(ShellEvent event) {
            }
        });
    }
}

