/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.cishell.utility.swt.URLClickedListener;
import org.cishell.utility.swt.URLMouseCursorListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SWTUtilities {
    public static final String URL_START_TAG = "[url]";
    public static final String URL_END_TAG = "[/url]";

    protected SWTUtilities() {
        throw new UnsupportedOperationException();
    }

    public static Collection<StyleRange> urlifyUrls(StyledText textField, URLClickedListener urlListener, URLMouseCursorListener urlCursorListener, String message, Color normalColor, Color urlColor) {
        boolean urlDetected;
        int startTagIndex = message.indexOf(URL_START_TAG);
        int endTagIndex = message.indexOf(URL_END_TAG);
        boolean bl = urlDetected = startTagIndex >= 0 && endTagIndex >= 0;
        if (urlDetected) {
            String urlWithTags = message.substring(startTagIndex, endTagIndex + URL_END_TAG.length());
            String url = urlWithTags.substring(URL_START_TAG.length(), urlWithTags.length() - URL_END_TAG.length());
            String messageWithFirstUrlDetagged = message.replaceFirst(Pattern.quote(urlWithTags), url);
            String messageBeforeUrl = messageWithFirstUrlDetagged.substring(0, startTagIndex);
            StyleRange preURLStyle = SWTUtilities.syncedStyledPrint(textField, messageBeforeUrl, normalColor, 0);
            urlListener.addURL(textField.getText().length(), url);
            urlCursorListener.addURL(textField.getText().length(), url);
            StyleRange urlStyle = SWTUtilities.syncedStyledPrint(textField, url, urlColor, 1);
            String messageBeyondFirstUrl = messageWithFirstUrlDetagged.substring(startTagIndex + url.length());
            Collection<StyleRange> postURLStyles = SWTUtilities.urlifyUrls(textField, urlListener, urlCursorListener, messageBeyondFirstUrl, normalColor, urlColor);
            HashSet<StyleRange> finalStyles = new HashSet<StyleRange>();
            if (preURLStyle != null) {
                finalStyles.add(preURLStyle);
            }
            if (urlStyle != null) {
                finalStyles.add(urlStyle);
            }
            finalStyles.addAll(postURLStyles);
            return finalStyles;
        }
        StyleRange style = SWTUtilities.syncedStyledPrint(textField, message, normalColor, 0);
        if (style != null) {
            HashSet<StyleRange> finalStyles = new HashSet<StyleRange>();
            finalStyles.add(style);
            return finalStyles;
        }
        return new HashSet<StyleRange>();
    }

    public static StyleRange syncedStyledPrint(final StyledText textField, final String message, final Color color, final int style) {
        final StyleRange[] styleRange = new StyleRange[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                styleRange[0] = SWTUtilities.styledPrint(textField, message, color, style);
            }
        });
        return styleRange[0];
    }

    public static StyleRange styledPrint(StyledText textField, String message, Color color, int style) {
        if (!textField.isDisposed()) {
            textField.append(message);
            StyleRange styleRange = new StyleRange();
            styleRange.start = textField.getText().length() - message.length();
            styleRange.length = message.length();
            styleRange.foreground = color;
            styleRange.fontStyle = style;
            textField.setStyleRange(styleRange);
            textField.setTopIndex(textField.getLineCount());
            return styleRange;
        }
        return null;
    }

    public static StyleRange printURL(Composite parent, StyledText textField, String url, String displayURL, Color color, int style) {
        URLClickedListener urlClickedListener = new URLClickedListener(textField);
        URLMouseCursorListener urlCursorListener = new URLMouseCursorListener(parent, textField);
        textField.addMouseListener((MouseListener)urlClickedListener);
        textField.addMouseMoveListener((MouseMoveListener)urlCursorListener);
        urlClickedListener.addURL(textField.getText().length(), url, displayURL);
        urlCursorListener.addURL(textField.getText().length(), url, displayURL);
        return SWTUtilities.styledPrint(textField, displayURL, color, style);
    }
}

