/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;

public class URLClickedListener
extends MouseAdapter {
    private Map<Integer, String> offsetsToURLs = new HashMap<Integer, String>();
    private Map<String, String> urlsToDisplayURLs = new HashMap<String, String>();
    private StyledText textField;

    public URLClickedListener(StyledText textField) {
        this.textField = textField;
    }

    public void addURL(int offset, String url) {
        this.addURL(offset, url, url);
    }

    public void addURL(int offset, String url, String displayURL) {
        this.offsetsToURLs.put(offset, url);
        this.urlsToDisplayURLs.put(url, displayURL);
    }

    public void mouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        int clickedPosition = this.determineClickedPosition(event);
        if (clickedPosition < 0) {
            return;
        }
        Integer[] integerArray = this.offsetsToURLs.keySet().toArray(new Integer[0]);
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer offset = integerArray[n2];
            String url = this.offsetsToURLs.get(offset);
            String displayURL = this.urlsToDisplayURLs.get(url);
            if (displayURL != null && clickedPosition >= offset && clickedPosition <= offset + displayURL.length()) {
                try {
                    Program.launch((String)url);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    private int determineClickedPosition(MouseEvent event) {
        int clickedPosition = -1;
        try {
            clickedPosition = this.textField.getOffsetAtLocation(new Point(event.x, event.y));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return clickedPosition;
    }
}

