/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class URLMouseCursorListener
implements MouseMoveListener {
    private Map<Integer, String> offsetsToURLs = new HashMap<Integer, String>();
    private Map<String, String> urlsToDisplayURLs = new HashMap<String, String>();
    private Composite parent;
    private StyledText textField;

    public URLMouseCursorListener(Composite parent, StyledText textField) {
        this.parent = parent;
        this.textField = textField;
    }

    public void addURL(int offset, String url) {
        this.addURL(offset, url, url);
    }

    public void addURL(int offset, String url, String displayURL) {
        this.offsetsToURLs.put(new Integer(offset), url);
        this.urlsToDisplayURLs.put(url, displayURL);
    }

    public void mouseMove(MouseEvent event) {
        int urlOffsetOfMousePosition = this.determineURLOffsetOfMousePosition(event);
        Integer[] urlOffsets = this.offsetsToURLs.keySet().toArray(new Integer[0]);
        boolean mouseIsOverURL = this.determineIfMouseIsHoveringOverURL(urlOffsetOfMousePosition, urlOffsets);
        Cursor cursor = new Cursor((Device)this.parent.getDisplay(), this.determineMouseCursor(mouseIsOverURL));
        this.textField.setCursor(cursor);
    }

    private int determineURLOffsetOfMousePosition(MouseEvent event) {
        try {
            return this.textField.getOffsetAtLocation(new Point(event.x, event.y));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Cursor cursor = new Cursor((Device)this.parent.getDisplay(), 0);
            this.textField.setCursor(cursor);
            return -1;
        }
    }

    private boolean determineIfMouseIsHoveringOverURL(int urlOffsetOfMousePosition, Integer[] urlOffsets) {
        Integer[] integerArray = urlOffsets;
        int n = urlOffsets.length;
        int n2 = 0;
        while (n2 < n) {
            Integer urlOffset = integerArray[n2];
            String url = this.offsetsToURLs.get(urlOffset);
            if (urlOffset != null && url != null && urlOffsetOfMousePosition >= urlOffset && urlOffsetOfMousePosition <= urlOffset + url.length()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int determineMouseCursor(boolean mouseIsOverURL) {
        if (mouseIsOverURL) {
            return 21;
        }
        return 0;
    }
}

