/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.cishell.utilities.StringUtilities;
import org.cishell.utility.datastructure.datamodel.DataModel;
import org.cishell.utility.datastructure.datamodel.area.DataModelArea;
import org.cishell.utility.datastructure.datamodel.exception.ModelStructureException;
import org.cishell.utility.datastructure.datamodel.exception.UniqueNameException;
import org.cishell.utility.datastructure.datamodel.field.DataModelField;
import org.cishell.utility.datastructure.datamodel.group.DataModelGroup;
import org.cishell.utility.datastructure.datamodel.gui.AbstractGUIDataModel;
import org.cishell.utility.swt.model.SWTModelArea;
import org.cishell.utility.swt.model.SWTModelField;
import org.cishell.utility.swt.model.datasynchronizer.CheckBoxDataSynchronizer;
import org.cishell.utility.swt.model.datasynchronizer.DropDownDataSynchronizer;
import org.cishell.utility.swt.model.datasynchronizer.SingleListSelectionDataSynchronizer;
import org.cishell.utility.swt.model.datasynchronizer.TextDataSynchronizer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SWTModel
extends AbstractGUIDataModel<Widget, Composite> {
    private int newAreaStyle;

    public SWTModel(int newAreaStyle) {
        this.newAreaStyle = newAreaStyle;
    }

    public DataModelArea createArea(String name, Object componentForArea) throws ClassCastException, ModelStructureException, UniqueNameException {
        if (this.getArea(name) != null) {
            String exceptionMessage = String.format("The area '%s' already exists.  All areas must have unique names.", name);
            throw new UniqueNameException(exceptionMessage);
        }
        SWTModelArea area = new SWTModelArea(null, null, name, (Composite)componentForArea, this.newAreaStyle);
        this.addArea((DataModelArea)area);
        return area;
    }

    protected DataModelArea createGUISpecificArea(String name) {
        Composite parent = (Composite)this.getCurrentParentComponent();
        return new SWTModelArea(null, parent, name, this.newAreaStyle);
    }

    public DataModelField<Boolean> addCheckBox(String name, String areaName, String groupName, boolean defaultOn) throws UniqueNameException {
        return this.addCheckBox(name, areaName, groupName, defaultOn, (Composite)this.getCurrentParentComponent(), 0);
    }

    public SWTModelField<Boolean, Button, CheckBoxDataSynchronizer> addCheckBox(String name, String areaName, String groupName, boolean on, Composite parent, int style) throws UniqueNameException {
        Button checkBox = new Button(parent, style | 0x20);
        CheckBoxDataSynchronizer dataSynchronizer = new CheckBoxDataSynchronizer(checkBox, on);
        SWTModelField<Boolean, Button, CheckBoxDataSynchronizer> field = new SWTModelField<Boolean, Button, CheckBoxDataSynchronizer>((DataModel)this, name, parent, on, checkBox, dataSynchronizer);
        this.addField(areaName, groupName, field);
        return field;
    }

    public <T> DataModelField<T> addDropDown(String name, String areaName, String groupName, int selectedIndex, Collection<String> unorderedOptionLabels, Map<String, T> optionValuesByLabels) throws UniqueNameException {
        return this.addDropDown(name, areaName, groupName, selectedIndex, unorderedOptionLabels, optionValuesByLabels, (Composite)this.getCurrentParentComponent(), 2056);
    }

    public <T> SWTModelField<T, Combo, DropDownDataSynchronizer<T>> addDropDown(String name, String areaName, String groupName, int selectedIndex, Collection<String> unorderedOptionLabels, Map<String, T> optionValuesByLabels, Composite parent, int style) throws UniqueNameException {
        ArrayList<String> orderedOptionLabels = new ArrayList<String>(unorderedOptionLabels);
        Combo dropDown = new Combo(parent, style | 4);
        DropDownDataSynchronizer<T> dataSynchronizer = new DropDownDataSynchronizer<T>(dropDown, selectedIndex, orderedOptionLabels, optionValuesByLabels);
        SWTModelField<T, Combo, DropDownDataSynchronizer<T>> field = new SWTModelField<T, Combo, DropDownDataSynchronizer<T>>((DataModel)this, name, parent, optionValuesByLabels.get(orderedOptionLabels.get(selectedIndex)), dropDown, dataSynchronizer);
        this.addField(areaName, groupName, field);
        return field;
    }

    public <T> DataModelField<T> addList(String name, String areaName, String groupName, int selectedIndex, Collection<String> unorderedOptionLabels, Map<String, T> optionValuesByLabels) throws UniqueNameException {
        return this.addList(name, areaName, groupName, selectedIndex, unorderedOptionLabels, optionValuesByLabels, (Composite)this.getCurrentParentComponent(), 0);
    }

    public <T> SWTModelField<T, List, SingleListSelectionDataSynchronizer<T>> addList(String name, String areaName, String groupName, int selectedIndex, Collection<String> unorderedOptionLabels, Map<String, T> optionValuesByLabels, Composite parent, int style) throws UniqueNameException {
        ArrayList<String> orderedOptionLabels = new ArrayList<String>(unorderedOptionLabels);
        List list = new List(parent, style | 4);
        SingleListSelectionDataSynchronizer<T> dataSynchronizer = new SingleListSelectionDataSynchronizer<T>(list, selectedIndex, orderedOptionLabels, optionValuesByLabels);
        SWTModelField<T, List, SingleListSelectionDataSynchronizer<T>> field = new SWTModelField<T, List, SingleListSelectionDataSynchronizer<T>>((DataModel)this, name, parent, dataSynchronizer.value(), list, dataSynchronizer);
        this.addField(areaName, groupName, field);
        return field;
    }

    public DataModelField<String> addText(String name, String areaName, String groupName, String defaultValue, boolean isMultiLined) throws UniqueNameException {
        return this.addText(name, areaName, groupName, defaultValue, isMultiLined, (Composite)this.getCurrentParentComponent(), 0);
    }

    public SWTModelField<String, Text, TextDataSynchronizer> addText(String name, String areaName, String groupName, String defaultValue, boolean isMultiLined, Composite parent, int style) throws UniqueNameException {
        style = isMultiLined ? (style |= 2) : (style |= 4);
        Text text = new Text(parent, style);
        TextDataSynchronizer dataSynchronizer = new TextDataSynchronizer(text, defaultValue);
        SWTModelField<String, Text, TextDataSynchronizer> field = new SWTModelField<String, Text, TextDataSynchronizer>((DataModel)this, name, parent, defaultValue, text, dataSynchronizer);
        this.addField(areaName, groupName, field);
        return field;
    }

    public <T> void addField(String areaName, String groupName, DataModelField<T> field) throws UniqueNameException {
        DataModelGroup group;
        DataModelArea area = this.getArea(areaName);
        if (area != null) {
            area.addField(field);
        }
        if (StringUtilities.isNull_Empty_OrWhitespace((String)groupName)) {
            groupName = "defaultGroup";
        }
        if ((group = this.getGroup(groupName)) == null) {
            group = this.createGroup(groupName);
        }
        group.addField(field);
    }
}

