/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt.model.datasynchronizer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import org.cishell.utilities.MapUtilities;
import org.cishell.utility.datastructure.datamodel.ModelDataSynchronizer;
import org.eclipse.swt.widgets.Combo;

public class DropDownDataSynchronizer<T>
implements ModelDataSynchronizer<T> {
    private Combo dropDown;
    private BiMap<Integer, String> optionLabels;
    private BiMap<String, T> optionValuesByLabels;

    public DropDownDataSynchronizer(Combo dropDown, int selectedIndex, List<String> optionLabels, Map<String, T> optionValuesByLabels) {
        this.dropDown = dropDown;
        this.setOptions(optionLabels, optionValuesByLabels);
        this.dropDown.select(selectedIndex);
    }

    public int updateListenerCode() {
        return 13;
    }

    public T value() {
        return (T)this.optionValuesByLabels.get(this.optionLabels.get((Object)this.dropDown.getSelectionIndex()));
    }

    public T synchronizeFromGUI() {
        return this.value();
    }

    public T synchronizeToGUI(T value) {
        String label = (String)this.optionValuesByLabels.inverse().get(value);
        this.dropDown.select(((Integer)this.optionLabels.inverse().get((Object)label)).intValue());
        return this.value();
    }

    public T reset(T defaultValue) {
        return this.synchronizeToGUI(defaultValue);
    }

    public void setOptions(List<String> optionLabels, Map<String, T> optionValuesByLabels) {
        this.optionLabels = HashBiMap.create((Map)MapUtilities.mapIndexToValues(optionLabels));
        this.optionValuesByLabels = HashBiMap.create(optionValuesByLabels);
        this.dropDown.setItems(optionLabels.toArray(new String[0]));
        this.dropDown.select(0);
    }
}

