/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.utility.swt.model.datasynchronizer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import org.cishell.utilities.MapUtilities;
import org.cishell.utility.datastructure.datamodel.ModelDataSynchronizer;

public class SingleListSelectionDataSynchronizer<T>
implements ModelDataSynchronizer<T> {
    private org.eclipse.swt.widgets.List singleSelectionList;
    private BiMap<Integer, String> optionLabels;
    private Map<String, T> optionValuesByLabels;

    public SingleListSelectionDataSynchronizer(org.eclipse.swt.widgets.List singleSelectionList, int selectedIndex, List<String> optionLabels, Map<String, T> optionValuesByLabels) {
        this.singleSelectionList = singleSelectionList;
        this.optionLabels = HashBiMap.create((Map)MapUtilities.mapIndexToValues(optionLabels));
        this.optionValuesByLabels = optionValuesByLabels;
        this.singleSelectionList.setItems(optionLabels.toArray(new String[0]));
        this.singleSelectionList.select(selectedIndex);
    }

    public int updateListenerCode() {
        return 13;
    }

    public T value() {
        return this.optionValuesByLabels.get(this.optionLabels.get((Object)this.singleSelectionList.getSelectionIndex()));
    }

    public T synchronizeFromGUI() {
        return this.value();
    }

    public T synchronizeToGUI(T value) {
        this.singleSelectionList.select(((Integer)this.optionLabels.inverse().get(value)).intValue());
        return this.value();
    }

    public T reset(T defaultValue) {
        return this.synchronizeToGUI(defaultValue);
    }
}

